/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.input;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Message;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.forwarder.BatchControl;
import org.rvpf.forwarder.ForwarderMessages;
import org.rvpf.forwarder.ForwarderModule;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;

public abstract class InputModule
extends ForwarderModule.Abstract
implements ServiceThread.Target {
    private static final int _DEFAULT_BATCH_LIMIT = 100;
    private volatile ModuleInput _input;
    private final Object _mutex = new Object();
    private final AtomicReference<ServiceThread> _thread = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() throws InterruptedException {
        ModuleInput input = this._input;
        boolean failed = false;
        while (true) {
            block25: {
                boolean loggedFailed = false;
                while (true) {
                    boolean opened = false;
                    if (this.isReliable()) {
                        opened = input.open();
                    }
                    ServiceThread.ready();
                    if (!this.isReliable()) {
                        opened = input.open();
                    }
                    if (opened) {
                        if (this.isReliable()) break;
                        Message message = new Message((Messages.Entry)ForwarderMessages.CONNECTION_COMPLETED, new Object[]{input.getSourceName()});
                        if (failed) {
                            this.getThisLogger().info(message);
                            failed = false;
                            break;
                        }
                        this.getThisLogger().debug(message);
                        break;
                    }
                    if (!loggedFailed) {
                        if (this.isReliable()) {
                            this.getThisLogger().warn((Messages.Entry)ForwarderMessages.CONNECTION_FAILED, new Object[]{input.getSourceName()});
                            this.getService().fail();
                            return;
                        }
                        this.getThisLogger().warn((Messages.Entry)ForwarderMessages.CONNECTION_FAILED_SLEEPING, new Object[]{input.getSourceName()});
                        loggedFailed = true;
                        failed = true;
                    }
                    this.getService().snooze(this.getConnectionRetryDelay());
                }
                do {
                    Optional<Serializable[]> messages = input.input(this.getBatchControl());
                    Object object = this._mutex;
                    synchronized (object) {
                        block26: {
                            if (this._thread.get() == null) {
                                throw new InterruptedException();
                            }
                            if (!messages.isPresent()) {
                                break block25;
                            }
                            if (this.getThisLogger().isDebugEnabled()) {
                                String from = input.getSourceName();
                                for (Serializable message : messages.get()) {
                                    this.getThisLogger().trace((Messages.Entry)ForwarderMessages.MESSAGE_FROM, new Object[]{from, message});
                                }
                            }
                            try {
                                if (this.output(this.filter(messages.get()))) {
                                    if (input.commit()) break block26;
                                    if (this.isReliable() && !input.isClosed()) {
                                        throw new ServiceNotAvailableException();
                                    }
                                    break block25;
                                }
                                if (!input.rollback() && this.isReliable() && !input.isClosed()) {
                                    throw new ServiceNotAvailableException();
                                }
                            }
                            catch (ServiceNotAvailableException exception) {
                                this.getThisLogger().error((Throwable)exception, (Messages.Entry)ServiceMessages.RESTART_NEEDED, new Object[0]);
                                this.getService().restart(true);
                            }
                        }
                    }
                } while (this._thread.get() != null);
                throw new InterruptedException();
            }
            Object object = this._mutex;
            synchronized (object) {
                if (this._thread.get() == null) {
                    throw new InterruptedException();
                }
                input.close();
            }
            this.getThisLogger().warn((Messages.Entry)ForwarderMessages.CONNECTION_LOST, new Object[0]);
            failed = true;
        }
    }

    @Override
    public void start() {
        ServiceThread thread;
        ModuleInput input = this._input;
        if (input != null && this._thread.compareAndSet(null, thread = new ServiceThread(this, input.getDisplayName()))) {
            this.getThisLogger().debug((Messages.Entry)ServiceMessages.STARTING_THREAD, new Object[]{thread.getName()});
            Require.ignored((boolean)thread.start(true));
        }
    }

    @Override
    public void stop() {
        ServiceThread thread = this._thread.getAndSet(null);
        if (thread != null) {
            this.getThisLogger().debug((Messages.Entry)ServiceMessages.STOPPING_THREAD, new Object[]{thread.getName()});
            thread.interrupt();
            ModuleInput input = this._input;
            if (input != null) {
                input.close();
            }
            Require.ignored((boolean)thread.join(this.getThisLogger(), this.getService().getJoinTimeout()));
        }
    }

    @Override
    public void tearDown() {
        ModuleInput input = this._input;
        if (input != null) {
            this._input = null;
            input.tearDown();
        }
        super.tearDown();
    }

    @Override
    protected int getDefaultBatchLimit() {
        return 100;
    }

    @Nonnull
    @CheckReturnValue
    protected final ModuleInput getInput() {
        return (ModuleInput)Require.notNull((Object)this._input);
    }

    @CheckReturnValue
    protected final boolean output(@Nonnull Serializable[] messages) throws InterruptedException, ServiceNotAvailableException {
        return this.getForwarderAppImpl().output(messages);
    }

    protected final void setInput(@Nonnull ModuleInput input) {
        this._input = input;
    }

    @Override
    protected boolean setUp(KeyedGroups moduleProperties) {
        ModuleInput input = this._input;
        if (input != null) {
            if (!input.setUp(moduleProperties)) {
                return false;
            }
            if (!this.getReliable().isPresent()) {
                this.setReliable(input.isReliable());
            }
        }
        return true;
    }

    protected static abstract class AbstractInput
    extends ForwarderModule.Abstract.AbstractInputOutput
    implements ModuleInput {
        protected AbstractInput() {
        }

        @Override
        public boolean rollback() {
            return true;
        }
    }

    protected static interface ModuleInput
    extends ForwarderModule.Abstract.ModuleInputOutput {
        @Nonnull
        @CheckReturnValue
        public String getSourceName();

        @Nonnull
        @CheckReturnValue
        public Optional<Serializable[]> input(@Nonnull BatchControl var1) throws InterruptedException;

        @CheckReturnValue
        public boolean rollback();
    }
}

