/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.input;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPInputStream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.xml.streamer.Streamer;
import org.rvpf.forwarder.BatchControl;
import org.rvpf.forwarder.ForwarderMessages;
import org.rvpf.forwarder.input.InputModule;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;

public final class MessagesFilesModule
extends InputModule {
    public static final String COMPRESSED_SUFFIX_PROPERTY = "input.compressed.suffix";
    public static final String DATA_PREFIX_PROPERTY = "input.prefix.data";
    public static final String DATA_SUFFIX_PROPERTY = "input.suffix.data";
    public static final String DEFAULT_COMPRESSED_SUFFIX = ".gz";
    public static final String DEFAULT_DATA_SUFFIX = ".data";
    public static final String DEFAULT_DONE_SUFFIX = ".backup";
    public static final ElapsedTime DEFAULT_SCAN_INTERVAL = ElapsedTime.fromMillis((long)60000L);
    public static final String DONE_PREFIX_PROPERTY = "input.prefix.done";
    public static final String DONE_SUFFIX_PROPERTY = "input.suffix.done";
    public static final String INPUT_DIR_PROPERTY = "input.dir";
    public static final String SCAN_INTERVAL_PROPERTY = "input.scan.interval";
    public static final String SEM_DIR_PROPERTY = "sem.dir";
    public static final String SEM_MATCH_ENABLED_PROPERTY = "sem.match.enabled";
    public static final String SEM_PREFIX_PROPERTY = "sem.prefix";
    public static final String SEM_PURGE_ENABLED_PROPERTY = "sem.purge.enabled";
    public static final String SEM_SUFFIX_PROPERTY = "sem.suffix";
    private String _compressedSuffix;
    private String _dataPrefix;
    private String _dataSuffix;
    private String _donePrefix;
    private String _doneSuffix;
    private _FilesWatcher _filesWatcher;
    private File _inputDirectory;
    private BlockingQueue<File> _inputFiles = new LinkedBlockingQueue<File>();
    private ElapsedTime _scanInterval;
    private File _semDirectory;
    private boolean _semMatchEnabled;
    private String _semPrefix;
    private boolean _semPurgeEnabled;
    private String _semSuffix;

    @Override
    public synchronized void start() {
        super.start();
        this._filesWatcher.start();
    }

    @Override
    public void stop() {
        this._filesWatcher.stop();
        super.stop();
    }

    @Override
    public void tearDown() {
        this._inputFiles.clear();
        super.tearDown();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean setUp(KeyedGroups moduleProperties) {
        Optional inputDir = moduleProperties.getString(INPUT_DIR_PROPERTY);
        if (!inputDir.isPresent()) {
            this.getThisLogger().error((Messages.Entry)BaseMessages.MISSING_PROPERTY, new Object[]{INPUT_DIR_PROPERTY});
            return false;
        }
        this._inputDirectory = new File((String)inputDir.get());
        if (!this._inputDirectory.isDirectory()) {
            if (!this._inputDirectory.mkdirs()) {
                this.getThisLogger().error((Messages.Entry)ForwarderMessages.INPUT_DIRECTORY_CREATE_FAILED, new Object[]{this._inputDirectory.getAbsolutePath()});
                return false;
            }
            this.getThisLogger().info((Messages.Entry)ForwarderMessages.INPUT_DIRECTORY_CREATED, new Object[]{this._inputDirectory});
        } else {
            this.getThisLogger().info((Messages.Entry)ForwarderMessages.INPUT_DIRECTORY, new Object[]{this._inputDirectory.getAbsolutePath()});
        }
        this._dataPrefix = ((String)moduleProperties.getString(DATA_PREFIX_PROPERTY, Optional.of("")).get()).trim().toLowerCase(Locale.ROOT);
        if (this._dataPrefix.length() > 0) {
            this.getThisLogger().info((Messages.Entry)ForwarderMessages.INPUT_FILE_PREFIX, new Object[]{this._dataPrefix});
        }
        this._scanInterval = moduleProperties.getElapsed(SCAN_INTERVAL_PROPERTY, Optional.of(DEFAULT_SCAN_INTERVAL), Optional.of(DEFAULT_SCAN_INTERVAL)).orElse(null);
        this.getThisLogger().info((Messages.Entry)ForwarderMessages.SCAN_INTERVAL, new Object[]{this._scanInterval});
        this._dataSuffix = ((String)moduleProperties.getString(DATA_SUFFIX_PROPERTY, Optional.of(DEFAULT_DATA_SUFFIX)).get()).toLowerCase(Locale.ROOT);
        if (!this._dataSuffix.equalsIgnoreCase(DEFAULT_DATA_SUFFIX)) {
            this.getThisLogger().info((Messages.Entry)ForwarderMessages.INPUT_FILE_SUFFIX, new Object[]{this._dataSuffix});
        }
        this._donePrefix = ((String)moduleProperties.getString(DONE_PREFIX_PROPERTY, Optional.of(this._dataPrefix)).get()).trim().toLowerCase(Locale.ROOT);
        if (this._donePrefix.length() > 0) {
            this.getThisLogger().info((Messages.Entry)ForwarderMessages.DONE_FILE_PREFIX, new Object[]{this._donePrefix});
        }
        this._doneSuffix = (String)moduleProperties.getString(DONE_SUFFIX_PROPERTY, Optional.of(DEFAULT_DONE_SUFFIX)).get();
        if (!this._doneSuffix.equals(DEFAULT_DONE_SUFFIX)) {
            this.getThisLogger().info((Messages.Entry)ForwarderMessages.DONE_FILE_SUFFIX, new Object[]{this._doneSuffix});
        }
        this._compressedSuffix = ((String)moduleProperties.getString(COMPRESSED_SUFFIX_PROPERTY, Optional.of(DEFAULT_COMPRESSED_SUFFIX)).get()).toLowerCase(Locale.ROOT);
        if (!this._compressedSuffix.equalsIgnoreCase(DEFAULT_COMPRESSED_SUFFIX)) {
            this.getThisLogger().info((Messages.Entry)ForwarderMessages.COMPRESSED_SUFFIX, new Object[]{this._compressedSuffix});
        }
        this._semSuffix = moduleProperties.getString(SEM_SUFFIX_PROPERTY).orElse(null);
        if (this._semSuffix != null) {
            this.getThisLogger().info((Messages.Entry)ForwarderMessages.SEM_FILE_SUFFIX, new Object[]{this._semSuffix});
            this._semDirectory = new File((String)moduleProperties.getString(SEM_DIR_PROPERTY, inputDir).get());
            if (!this._semDirectory.isDirectory()) {
                this.getThisLogger().error((Messages.Entry)ForwarderMessages.SEM_DIR_MISSING, new Object[]{this._semDirectory.getAbsolutePath()});
                return false;
            }
            if (!this._semDirectory.equals(this._inputDirectory)) {
                this.getThisLogger().info((Messages.Entry)ForwarderMessages.SEM_DIR, new Object[]{this._semDirectory.getAbsolutePath()});
            }
            this._semPrefix = ((String)moduleProperties.getString(SEM_PREFIX_PROPERTY, Optional.of(this._dataPrefix)).get()).trim().toLowerCase(Locale.ROOT);
            if (this._semPrefix.length() > 0) {
                this.getThisLogger().info((Messages.Entry)ForwarderMessages.SEM_FILE_PREFIX, new Object[]{this._semPrefix});
            }
            this._semMatchEnabled = moduleProperties.getBoolean(SEM_MATCH_ENABLED_PROPERTY);
            if (this._semMatchEnabled) {
                this.getThisLogger().info((Messages.Entry)ForwarderMessages.SEM_MATCH_ENABLED, new Object[0]);
            }
            this._semPurgeEnabled = moduleProperties.getBoolean(SEM_PURGE_ENABLED_PROPERTY);
            if (this._semPurgeEnabled) {
                this.getThisLogger().info((Messages.Entry)ForwarderMessages.SEM_PURGE_ENABLED, new Object[0]);
            }
        }
        this._filesWatcher = new _FilesWatcher();
        this.setInput(new _FilesReader());
        return super.setUp(moduleProperties);
    }

    void _addInputFile(@Nonnull File inputFile) {
        this._inputFiles.add(inputFile);
        this.getThisLogger().trace((Messages.Entry)ForwarderMessages.INPUT_FILE_ADDED, new Object[]{inputFile});
    }

    void _clearInputFiles() {
        this._inputFiles.clear();
    }

    @Nonnull
    @CheckReturnValue
    String _getCompressedSuffix() {
        return this._compressedSuffix;
    }

    @Nonnull
    @CheckReturnValue
    String _getDataPrefix() {
        return this._dataPrefix;
    }

    @Nonnull
    @CheckReturnValue
    String _getDataSuffix() {
        return this._dataSuffix;
    }

    @Nonnull
    @CheckReturnValue
    String _getDonePrefix() {
        return this._donePrefix;
    }

    @Nonnull
    @CheckReturnValue
    String _getDoneSuffix() {
        return this._doneSuffix;
    }

    @Nonnull
    @CheckReturnValue
    File _getInputDirectory() {
        return this._inputDirectory;
    }

    @Nonnull
    @CheckReturnValue
    ElapsedTime _getScanInterval() {
        return this._scanInterval;
    }

    @Nonnull
    @CheckReturnValue
    File _getSemDirectory() {
        return (File)Require.notNull((Object)this._semDirectory);
    }

    @Nonnull
    @CheckReturnValue
    String _getSemPrefix() {
        return (String)Require.notNull((Object)this._semPrefix);
    }

    @Nonnull
    @CheckReturnValue
    String _getSemSuffix() {
        return (String)Require.notNull((Object)this._semSuffix);
    }

    @CheckReturnValue
    boolean _isSemEnabled() {
        return this._semSuffix != null;
    }

    @CheckReturnValue
    boolean _isSemMatchEnabled() {
        return this._semMatchEnabled;
    }

    @CheckReturnValue
    boolean _isSemPurgeEnabled() {
        return this._semPurgeEnabled;
    }

    @Nonnull
    @CheckReturnValue
    File _takeInputFile() throws InterruptedException {
        return this._inputFiles.take();
    }

    private final class _FilesWatcher
    implements ServiceThread.Target {
        private final FileFilter _inputFilter;
        private final Logger _logger = Logger.getInstance(this.getClass());
        private final FileFilter _semFilter;
        private long _semTime;
        private final AtomicReference<ServiceThread> _thread = new AtomicReference();
        private final WatchService _watchService;

        _FilesWatcher() {
            this._inputFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    long semTime;
                    String name = file.getName();
                    String nameLower = name.toLowerCase(Locale.ROOT);
                    if (!nameLower.startsWith(MessagesFilesModule.this._getDataPrefix())) {
                        return false;
                    }
                    if (nameLower.endsWith(MessagesFilesModule.this._getCompressedSuffix())) {
                        name = name.substring(0, name.length() - MessagesFilesModule.this._getCompressedSuffix().length());
                        nameLower = name.toLowerCase(Locale.ROOT);
                    }
                    if (!nameLower.endsWith(MessagesFilesModule.this._getDataSuffix())) {
                        return false;
                    }
                    if (!MessagesFilesModule.this._isSemEnabled()) {
                        return true;
                    }
                    if (MessagesFilesModule.this._isSemMatchEnabled()) {
                        name = name.substring(MessagesFilesModule.this._getDataPrefix().length(), name.length() - MessagesFilesModule.this._getDataSuffix().length());
                        File semFile = new File(MessagesFilesModule.this._getSemDirectory(), MessagesFilesModule.this._getSemPrefix() + name + MessagesFilesModule.this._getSemSuffix());
                        semTime = semFile.isFile() ? semFile.lastModified() : 0L;
                    } else {
                        semTime = _FilesWatcher.this._getSemTime();
                    }
                    return semTime >= file.lastModified();
                }
            };
            try {
                this._watchService = FileSystems.getDefault().newWatchService();
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            this._semFilter = MessagesFilesModule.this._isSemEnabled() ? new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String name = file.getName().toLowerCase(Locale.ROOT);
                    return name.startsWith(MessagesFilesModule.this._getSemPrefix()) && name.endsWith(MessagesFilesModule.this._getSemSuffix());
                }
            } : null;
        }

        @Override
        public void run() throws IOException, InterruptedException {
            try {
                WatchKey watchKey;
                this._scanInputDirectory();
                MessagesFilesModule.this._getInputDirectory().toPath().register(this._watchService, StandardWatchEventKinds.ENTRY_CREATE);
                if (MessagesFilesModule.this._isSemEnabled() && !MessagesFilesModule.this._getInputDirectory().equals(MessagesFilesModule.this._getSemDirectory())) {
                    MessagesFilesModule.this._getSemDirectory().toPath().register(this._watchService, StandardWatchEventKinds.ENTRY_CREATE);
                }
                ServiceThread.ready();
                block2: do {
                    watchKey = this._watchService.take();
                    for (WatchEvent<?> event : watchKey.pollEvents()) {
                        if (event.kind() == StandardWatchEventKinds.OVERFLOW) {
                            this._logger.error((Messages.Entry)ForwarderMessages.INPUT_DIRECTORY_OVERFLOW, new Object[]{watchKey.watchable()});
                            MessagesFilesModule.this._clearInputFiles();
                            this._scanInputDirectory();
                            continue block2;
                        }
                        Path path = ((Path)watchKey.watchable()).resolve(event.context().toString());
                        File file = path.toFile();
                        if (MessagesFilesModule.this._isSemEnabled() && this._semFilter.accept(path.toFile())) {
                            if (MessagesFilesModule.this._isSemMatchEnabled()) {
                                String fileName = file.getName();
                                String name = fileName.substring(MessagesFilesModule.this._getSemPrefix().length(), fileName.length() - MessagesFilesModule.this._getSemSuffix().length());
                                File inputFile = new File(MessagesFilesModule.this._getInputDirectory(), MessagesFilesModule.this._getDataPrefix() + name + MessagesFilesModule.this._getDataSuffix());
                                if (!inputFile.isFile() || inputFile.lastModified() > file.lastModified()) continue;
                                MessagesFilesModule.this._addInputFile(inputFile);
                                continue;
                            }
                            MessagesFilesModule.this._clearInputFiles();
                            this._scanInputDirectory();
                            continue block2;
                        }
                        if (!this._inputFilter.accept(file)) continue;
                        MessagesFilesModule.this._addInputFile(new File(MessagesFilesModule.this._getInputDirectory(), file.getName()));
                    }
                } while (watchKey.reset());
            }
            catch (ClosedWatchServiceException exception) {
                throw new InterruptedException();
            }
        }

        @CheckReturnValue
        long _getSemTime() {
            return this._semTime;
        }

        void start() {
            ServiceThread thread = new ServiceThread(this, "Streamed messages files watcher");
            if (this._thread.compareAndSet(null, thread)) {
                MessagesFilesModule.this.getThisLogger().debug((Messages.Entry)ServiceMessages.STARTING_THREAD, new Object[]{thread.getName()});
                Require.ignored((boolean)thread.start(true));
            }
        }

        void stop() {
            ServiceThread thread = this._thread.getAndSet(null);
            if (thread != null) {
                MessagesFilesModule.this.getThisLogger().debug((Messages.Entry)ServiceMessages.STOPPING_THREAD, new Object[]{thread.getName()});
                try {
                    this._watchService.close();
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            }
        }

        private void _scanInputDirectory() {
            File[] inputFiles;
            File[] semFiles;
            if (MessagesFilesModule.this._isSemMatchEnabled() && MessagesFilesModule.this._isSemPurgeEnabled()) {
                for (File semFile : semFiles = (File[])Require.notNull((Object)MessagesFilesModule.this._getSemDirectory().listFiles(this._semFilter))) {
                    String name = semFile.getName().substring(MessagesFilesModule.this._getSemPrefix().length());
                    name = MessagesFilesModule.this._getDataPrefix() + name.substring(0, name.length() - MessagesFilesModule.this._getSemSuffix().length()) + MessagesFilesModule.this._getDataSuffix();
                    if (new File(MessagesFilesModule.this._getInputDirectory(), name).isFile() || new File(MessagesFilesModule.this._getInputDirectory(), name + MessagesFilesModule.this._getCompressedSuffix()).isFile() || !semFile.delete()) continue;
                    this._logger.debug((Messages.Entry)ForwarderMessages.PURGED_SEM_FILE, new Object[]{semFile});
                }
            }
            if (MessagesFilesModule.this._isSemEnabled() && !MessagesFilesModule.this._isSemMatchEnabled()) {
                for (File semFile : semFiles = (File[])Require.notNull((Object)MessagesFilesModule.this._getSemDirectory().listFiles(this._semFilter))) {
                    this._semTime = Math.max(this._semTime, semFile.lastModified());
                }
                if (MessagesFilesModule.this._isSemPurgeEnabled()) {
                    for (File semFile : semFiles) {
                        if (semFile.lastModified() >= this._semTime || !semFile.delete()) continue;
                        this._logger.debug((Messages.Entry)ForwarderMessages.PURGED_SEM_FILE, new Object[]{semFile});
                    }
                }
            }
            for (File inputFile : inputFiles = (File[])Require.notNull((Object)MessagesFilesModule.this._getInputDirectory().listFiles(this._inputFilter))) {
                MessagesFilesModule.this._addInputFile(new File(MessagesFilesModule.this._getInputDirectory(), inputFile.getName()));
            }
        }
    }

    private final class _FilesReader
    extends InputModule.AbstractInput
    implements ServiceThread.Target {
        private List<Serializable> _entries;
        private final Logger _logger = Logger.getInstance(this.getClass());
        private final Streamer _streamer = Streamer.newInstance();
        private final AtomicReference<ServiceThread> _thread = new AtomicReference();

        _FilesReader() {
        }

        @Override
        public void close() {
            ServiceThread thread = this._thread.getAndSet(null);
            if (thread != null) {
                MessagesFilesModule.this.getThisLogger().debug((Messages.Entry)ServiceMessages.STOPPING_THREAD, new Object[]{thread.getName()});
                Require.ignored((boolean)thread.interruptAndJoin(MessagesFilesModule.this.getThisLogger(), MessagesFilesModule.this.getService().getJoinTimeout()));
            }
        }

        @Override
        public synchronized boolean commit() {
            this._entries = null;
            this.notifyAll();
            return super.commit();
        }

        @Override
        public String getDisplayName() {
            return "Streamed messages files";
        }

        @Override
        public String getSourceName() {
            return MessagesFilesModule.this._getInputDirectory().getName();
        }

        @Override
        public synchronized Optional<Serializable[]> input(BatchControl batchControl) throws InterruptedException {
            while (this._entries == null) {
                this.wait();
            }
            return Optional.of(this._entries.toArray(new Serializable[this._entries.size()]));
        }

        @Override
        public boolean isClosed() {
            return this._thread == null;
        }

        @Override
        public boolean isReliable() {
            return true;
        }

        @Override
        public boolean open() {
            ServiceThread thread = new ServiceThread(this, "Streamed messages files reader");
            if (this._thread.compareAndSet(null, thread)) {
                MessagesFilesModule.this.getThisLogger().debug((Messages.Entry)ServiceMessages.STARTING_THREAD, new Object[]{thread.getName()});
                thread.start();
            }
            return true;
        }

        @Override
        public void run() throws InterruptedException {
            int batchLimit = MessagesFilesModule.this.getBatchControl().getLimit();
            while (true) {
                File semFile;
                InputStream inputStream;
                File inputFile = MessagesFilesModule.this._takeInputFile();
                String fileName = inputFile.getName();
                boolean compressed = fileName.toLowerCase(Locale.ROOT).endsWith(MessagesFilesModule.this._getCompressedSuffix());
                try {
                    inputStream = Files.newInputStream(inputFile.toPath(), new OpenOption[0]);
                }
                catch (NoSuchFileException exception) {
                    this._logger.debug((Messages.Entry)ForwarderMessages.INPUT_FILE_DISAPPEARED, new Object[]{inputFile});
                    continue;
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
                if (compressed) {
                    try {
                        inputStream = new GZIPInputStream(inputStream);
                    }
                    catch (IOException exception) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException closeException) {
                            throw new RuntimeException(closeException);
                        }
                        throw new RuntimeException(exception);
                    }
                }
                this._logger.debug((Messages.Entry)ForwarderMessages.PROCESSING_FILE, new Object[]{inputFile});
                String name = fileName.substring(MessagesFilesModule.this._getDataPrefix().length(), fileName.length() - (MessagesFilesModule.this._getDataSuffix().length() + (compressed ? MessagesFilesModule.this._getCompressedSuffix().length() : 0)));
                File doneFile = new File(MessagesFilesModule.this._getInputDirectory(), MessagesFilesModule.this._getDonePrefix() + name + MessagesFilesModule.this._getDoneSuffix() + (compressed ? MessagesFilesModule.this._getCompressedSuffix() : ""));
                if (doneFile.delete()) {
                    this._logger.debug((Messages.Entry)ForwarderMessages.DELETED_OLD_DONE_FILE, new Object[]{doneFile});
                }
                Streamer.Input input = this._streamer.newInput(inputStream, Optional.empty());
                LinkedList<Serializable> entries = new LinkedList<Serializable>();
                while (input.hasNext()) {
                    if (entries.size() >= batchLimit) {
                        this._flush(entries);
                        entries.clear();
                    }
                    Serializable message = input.next();
                    entries.add(message);
                    MessagesFilesModule.this.getTraces().add((Object)message);
                }
                if (!entries.isEmpty()) {
                    this._flush(entries);
                }
                input.close();
                if (!inputFile.renameTo(doneFile)) {
                    this._logger.error((Messages.Entry)BaseMessages.FILE_RENAME_FAILED, new Object[]{inputFile, doneFile});
                    return;
                }
                this._logger.debug((Messages.Entry)ForwarderMessages.FILE_PROCESSED, new Object[]{inputFile});
                if (!MessagesFilesModule.this._isSemPurgeEnabled() || !(semFile = new File(MessagesFilesModule.this._getSemDirectory(), MessagesFilesModule.this._getSemPrefix() + name + MessagesFilesModule.this._getSemSuffix())).delete()) continue;
                this._logger.debug((Messages.Entry)ForwarderMessages.PURGED_SEM_FILE, new Object[]{semFile});
            }
        }

        @Override
        public boolean setUp(KeyedGroups moduleProperties) {
            if (!super.setUp(moduleProperties)) {
                return false;
            }
            return this._streamer.setUp(Optional.of(MessagesFilesModule.this.getConfigProperties()), Optional.of(moduleProperties));
        }

        @Override
        public void tearDown() {
            this._streamer.tearDown();
            super.tearDown();
        }

        private synchronized void _flush(@Nonnull List<Serializable> entries) throws InterruptedException {
            this._entries = entries;
            this.notifyAll();
            while (this._entries != null) {
                this.wait();
            }
        }
    }
}

