/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.input;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.rmi.AccessException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.security.Identity;
import org.rvpf.base.security.Realm;
import org.rvpf.base.security.SecurityContext;
import org.rvpf.base.security.ServerSecurityContext;
import org.rvpf.base.tool.Inet;
import org.rvpf.base.tool.Require;
import org.rvpf.base.tool.ValueConverter;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.xml.XMLDocument;
import org.rvpf.base.xml.XMLElement;
import org.rvpf.base.xml.streamer.Streamer;
import org.rvpf.forwarder.BatchControl;
import org.rvpf.forwarder.ForwarderMessages;
import org.rvpf.forwarder.input.InputModule;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;

public final class MessagesPortServerModule
extends InputModule {
    public static final String ADDRESS_PROPERTY = "address";
    public static final String CLIENT_ATTRIBUTE = "client";
    public static final String FLUSH_ATTRIBUTE = "flush";
    public static final String FLUSH_ELEMENT = "flush";
    public static final String ID_ATTRIBUTE = "id";
    public static final String LOGIN_ELEMENT = "login";
    public static final String MESSAGES_ELEMENT = "messages";
    public static final String PASSWORD_ATTRIBUTE = "password";
    public static final String ROLE_PROPERTY = "role";
    public static final String USER_ATTRIBUTE = "user";
    private final BlockingQueue<List<Serializable>> _queue = new SynchronousQueue<List<Serializable>>();
    private final Realm _realm = new Realm();
    private final Set<_Receiver> _receivers = new HashSet<_Receiver>();
    private volatile String[] _roles;
    private volatile Streamer _streamer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() {
        ArrayList<_Receiver> receivers;
        Set<_Receiver> set = this._receivers;
        synchronized (set) {
            receivers = new ArrayList<_Receiver>(this._receivers);
        }
        for (_Receiver receiver : receivers) {
            receiver._close();
        }
        if (this._streamer != null) {
            this._streamer.tearDown();
            this._streamer = null;
        }
        super.tearDown();
    }

    @Override
    protected boolean setUp(KeyedGroups moduleProperties) {
        ServerSocket serverSocket;
        ServerSocketFactory factory;
        boolean secure;
        String addressString = moduleProperties.getString(ADDRESS_PROPERTY).orElse(null);
        if (addressString == null) {
            this.getThisLogger().error((Messages.Entry)BaseMessages.MISSING_PROPERTY, new Object[]{ADDRESS_PROPERTY});
            return false;
        }
        this.getThisLogger().info((Messages.Entry)ForwarderMessages.ADDRESS, new Object[]{addressString});
        Optional socketAddress = Inet.socketAddress((String)addressString);
        if (!socketAddress.isPresent()) {
            this.getThisLogger().error((Messages.Entry)BaseMessages.BAD_ADDRESS, new Object[]{addressString});
            return false;
        }
        if (!Inet.isOnLocalHost((InetAddress)((InetSocketAddress)socketAddress.get()).getAddress())) {
            this.getThisLogger().warn((Messages.Entry)ServiceMessages.LISTEN_ADDRESS_NOT_LOCAL, new Object[]{((InetSocketAddress)socketAddress.get()).getAddress()});
            return false;
        }
        ServerSecurityContext securityContext = new ServerSecurityContext(this.getThisLogger());
        KeyedGroups securityProperties = moduleProperties.getGroup("security");
        if (!securityContext.setUp(this.getConfigProperties(), securityProperties)) {
            return false;
        }
        boolean bl = secure = securityContext.isCertified() || securityContext.isSecure() || !securityProperties.isEmpty() || !((InetSocketAddress)socketAddress.get()).getAddress().isLoopbackAddress();
        if (secure) {
            try {
                securityContext.checkForSecureOperation();
            }
            catch (SSLException exception) {
                this.getThisLogger().error((Messages.Entry)BaseMessages.VERBATIM, new Object[]{exception.getMessage()});
                return false;
            }
            try {
                factory = securityContext.createSSLContext().getServerSocketFactory();
            }
            catch (SSLException exception) {
                this.getThisLogger().error((Throwable)exception, (Messages.Entry)ServiceMessages.SSL_CREATE_FAILED, new Object[]{exception.getMessage()});
                return false;
            }
        }
        factory = ServerSocketFactory.getDefault();
        try {
            serverSocket = factory.createServerSocket();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        if (secure) {
            ((SSLServerSocket)serverSocket).setNeedClientAuth(securityContext.isCertified());
        }
        this._roles = moduleProperties.getStrings(ROLE_PROPERTY);
        if (this._roles.length > 0) {
            for (String role : this._roles) {
                this.getThisLogger().info((Messages.Entry)ForwarderMessages.AUTHORIZED_ROLE, new Object[]{role});
            }
            KeyedGroups realmProperties = securityContext.getRealmProperties();
            if (realmProperties.isMissing()) {
                this.getThisLogger().error((Messages.Entry)ServiceMessages.ROLES_REQUIRE_REALM, new Object[0]);
                return false;
            }
            if (!this._realm.setUp(realmProperties, (SecurityContext)securityContext)) {
                return false;
            }
        }
        this._streamer = Streamer.newInstance();
        if (!this._streamer.setUp(Optional.of(this.getConfigProperties()), Optional.of(moduleProperties))) {
            return false;
        }
        this.setInput(new _PortListener(serverSocket, (SocketAddress)socketAddress.get(), secure ? (securityContext.isCertified() ? BaseMessages.CONNECTION_CERTIFIED.toString() : BaseMessages.CONNECTION_SECURE.toString()) : BaseMessages.CONNECTION_LOCAL.toString(), this.getBatchControl().getWait()));
        return super.setUp(moduleProperties);
    }

    @Nonnull
    @CheckReturnValue
    BlockingQueue<List<Serializable>> _getQueue() {
        return this._queue;
    }

    @Nonnull
    @CheckReturnValue
    Realm _getRealm() {
        return (Realm)Require.notNull((Object)this._realm);
    }

    @Nonnull
    @CheckReturnValue
    Set<_Receiver> _getReceivers() {
        return this._receivers;
    }

    @Nonnull
    @CheckReturnValue
    String[] _getRoles() {
        return this._roles;
    }

    @Nonnull
    @CheckReturnValue
    Streamer _getStreamer() {
        return (Streamer)Require.notNull((Object)this._streamer);
    }

    private final class _Receiver
    implements ServiceThread.Target {
        private boolean _authorized;
        private final Optional<ElapsedTime> _batchWait;
        private Optional<String> _client;
        private final XMLDocument _document = new XMLDocument();
        private InputStream _input;
        private Logger _logger;
        private volatile List<Serializable> _messages;
        private final AtomicReference<_Monitor> _monitor = new AtomicReference();
        private volatile OutputStream _output;
        private volatile Reader _reader;
        private final AtomicReference<ServiceThread> _receiverThread = new AtomicReference();
        private String _reference;
        private volatile Socket _socket;
        private volatile long _time;

        _Receiver(Optional<ElapsedTime> batchWait) {
            this._setClient(Optional.empty());
            this._setAuthorized(MessagesPortServerModule.this._getRoles().length == 0);
            this._document.setElementHandler("/messages", Optional.of(new _MessagesHandler()));
            this._document.setElementHandler("/login", Optional.of(new _LoginHandler()));
            this._document.setElementHandler("/flush", Optional.of(new _FlushHandler()));
            this._batchWait = batchWait;
        }

        @Nonnull
        @CheckReturnValue
        public Optional<ElapsedTime> getBatchWait() {
            return this._batchWait;
        }

        @Override
        public void run() {
            try {
                Reader reader = this._reader;
                try {
                    while (true) {
                        this._document.parse(reader);
                        reader.reset();
                    }
                }
                catch (XMLDocument.ParseException exception) {
                    if (reader.markSupported()) {
                        throw exception;
                    }
                    this._close();
                }
            }
            catch (Exception exception) {
                this._failed(exception);
                this._close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void _addMessage(@Nonnull Serializable message) {
            this._getLogger().trace((Messages.Entry)ForwarderMessages.DECODED_VALUE, new Object[]{message});
            _Receiver _Receiver2 = this;
            synchronized (_Receiver2) {
                if (this._messages.size() >= MessagesPortServerModule.this.getBatchControl().getLimit()) {
                    this._flush(ForwarderMessages.FLUSH_BATCH_LIMIT, false);
                }
                this._messages.add(message);
            }
            MessagesPortServerModule.this.getTraces().add(this._client, (Object)message);
        }

        void _checkAuthorized() throws XMLDocument.ParseException {
            if (!this._authorized) {
                throw new XMLDocument.ParseException((Throwable)new AccessException(Message.format((Messages.Entry)ForwarderMessages.LOGIN_NEEDED, (Object[])new Object[0])));
            }
        }

        synchronized void _close() {
            _Monitor monitor = this._monitor.getAndSet(null);
            if (monitor != null) {
                ServiceThread monitorThread = monitor.getThread();
                MessagesPortServerModule.this.getThisLogger().debug((Messages.Entry)ServiceMessages.STOPPING_THREAD, new Object[]{monitorThread.getName()});
                monitorThread.interrupt();
                if (!this._messages.isEmpty()) {
                    this._flush(ForwarderMessages.FLUSH_CLOSE, true);
                }
                if (!this._socket.isClosed()) {
                    SocketAddress socketAddress = this._socket.getRemoteSocketAddress();
                    try {
                        this._output.close();
                        this._input.close();
                        this._socket.close();
                    }
                    catch (IOException exception) {
                        this._getLogger().warn((Messages.Entry)ForwarderMessages.CONNECTION_CLOSE_FAILED, new Object[]{socketAddress, exception.getMessage()});
                        return;
                    }
                    this._getLogger().debug((Messages.Entry)ForwarderMessages.CONNECTION_CLOSED, new Object[]{socketAddress});
                }
            }
        }

        void _done() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<done");
            if (this._reference != null && this._reference.length() > 0) {
                stringBuilder.append(" ref='");
                stringBuilder.append(this._reference);
                stringBuilder.append("'");
                this._reference = null;
            }
            stringBuilder.append("/>\n");
            this._respond(stringBuilder);
        }

        void _failed(@Nonnull Exception cause) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<failed");
            if (this._reference != null && this._reference.length() > 0) {
                stringBuilder.append(" ref='");
                stringBuilder.append(this._reference);
                stringBuilder.append("'");
            }
            stringBuilder.append(" exception='");
            stringBuilder.append(cause.getClass().getName());
            stringBuilder.append("'>");
            if (cause.getMessage() != null) {
                stringBuilder.append(XMLElement.escape((CharSequence)cause.getMessage().trim(), (char)'\''));
            }
            stringBuilder.append("</failed>\n");
            this._respond(stringBuilder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void _flush(@Nonnull Messages.Entry reason, boolean wait) {
            List<Serializable> messages;
            this._getLogger().debug((Messages.Entry)ForwarderMessages.FLUSHING_MESSAGES, new Object[]{reason});
            _Receiver _Receiver2 = this;
            synchronized (_Receiver2) {
                if (this._messages.isEmpty()) {
                    this._getLogger().debug((Messages.Entry)ForwarderMessages.FLUSHED_NOTHING, new Object[0]);
                    return;
                }
                messages = this._messages;
                this._messages = new LinkedList<Serializable>();
            }
            int count = messages.size();
            try {
                MessagesPortServerModule.this._getQueue().put(messages);
                this._getLogger().trace((Messages.Entry)ForwarderMessages.QUEUED_MESSAGES, new Object[0]);
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(exception);
            }
            MessagesPortServerModule.this.getTraces().commit();
            this._getLogger().debug((Messages.Entry)ForwarderMessages.FLUSHED_MESSAGES, new Object[]{String.valueOf(count), count});
            if (wait) {
                List<Serializable> list = messages;
                synchronized (list) {
                    while (!messages.isEmpty()) {
                        try {
                            messages.wait();
                        }
                        catch (InterruptedException exception) {
                            Thread.currentThread().interrupt();
                            throw new RuntimeException(exception);
                        }
                    }
                }
            }
        }

        @Nonnull
        @CheckReturnValue
        Logger _getLogger() {
            return this._logger;
        }

        @CheckReturnValue
        long _getTime() {
            return this._time;
        }

        void _keepReference(@Nonnull XMLElement element) {
            this._reference = element.getAttributeValue(MessagesPortServerModule.ID_ATTRIBUTE, Optional.empty()).orElse(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CheckReturnValue
        boolean _open(@Nonnull Socket socket) {
            this._messages = new LinkedList<Serializable>();
            _Receiver _Receiver2 = this;
            synchronized (_Receiver2) {
                this._socket = socket;
                try {
                    this._input = socket.getInputStream();
                    this._output = socket.getOutputStream();
                    XMLDocument.ElementReader reader = new XMLDocument.ElementReader(this._input);
                    this._document.setRootHandler(Optional.of(reader));
                    this._reader = reader;
                }
                catch (IOException exception) {
                    this._getLogger().error((Messages.Entry)ForwarderMessages.GET_STREAM_FAILED, new Object[]{socket.getRemoteSocketAddress(), exception.getMessage()});
                    return false;
                }
                _Monitor monitor = new _Monitor(socket.getRemoteSocketAddress());
                if (this._monitor.compareAndSet(null, monitor)) {
                    ServiceThread monitorThread = monitor.getThread();
                    MessagesPortServerModule.this.getThisLogger().debug((Messages.Entry)ServiceMessages.STARTING_THREAD, new Object[]{monitorThread.getName()});
                    monitorThread.start();
                }
            }
            ServiceThread receiverThread = new ServiceThread(this, "Streamed messages port (receiver on " + socket.getRemoteSocketAddress() + ")");
            if (this._receiverThread.compareAndSet(null, receiverThread)) {
                Set<_Receiver> set = MessagesPortServerModule.this._getReceivers();
                synchronized (set) {
                    MessagesPortServerModule.this._getReceivers().add(this);
                }
                MessagesPortServerModule.this.getThisLogger().debug((Messages.Entry)ServiceMessages.STARTING_THREAD, new Object[]{receiverThread.getName()});
                receiverThread.start();
            }
            return true;
        }

        void _setAuthorized(boolean authorized) {
            this._authorized = authorized;
        }

        void _setClient(@Nonnull Optional<String> client) {
            this._client = client;
            this._logger = Logger.getInstance(this.getClass());
            if (this._client.isPresent()) {
                this._logger.debug((Messages.Entry)ForwarderMessages.CLIENT, new Object[]{this._client.get()});
                this._logger = Logger.getInstance((String)(this.getClass().getName() + ':' + this._client.get()));
            }
        }

        void _setTime(long time) {
            this._time = time;
        }

        @CheckReturnValue
        private boolean _respond(@Nonnull StringBuilder response) {
            byte[] bytes = response.toString().getBytes(StandardCharsets.UTF_8);
            try {
                this._output.write(bytes);
            }
            catch (IOException exception) {
                this._getLogger().warn((Messages.Entry)ForwarderMessages.FAILED_TO_RESPOND, new Object[]{exception.getMessage()});
                return false;
            }
            return true;
        }

        private final class _Monitor
        implements ServiceThread.Target {
            private final SocketAddress _socketAddress;
            private final AtomicReference<ServiceThread> _thread = new AtomicReference();

            _Monitor(SocketAddress socketAddress) {
                this._socketAddress = socketAddress;
            }

            @Override
            public synchronized void run() throws InterruptedException {
                Optional<ElapsedTime> batchWait = _Receiver.this.getBatchWait();
                while (true) {
                    if (_Receiver.this._getTime() == 0L) {
                        this.wait();
                        continue;
                    }
                    long elapsedMillis = System.currentTimeMillis() - _Receiver.this._getTime();
                    if (elapsedMillis < 0L || !batchWait.isPresent() || elapsedMillis >= batchWait.get().toMillis()) {
                        _Receiver.this._flush(ForwarderMessages.FLUSH_TIME_LIMIT, true);
                        _Receiver.this._setTime(0L);
                        continue;
                    }
                    this.wait(batchWait.get().toMillis() - elapsedMillis);
                }
            }

            @Nonnull
            @CheckReturnValue
            ServiceThread getThread() {
                ServiceThread thread = this._thread.get();
                if (thread == null && this._thread.compareAndSet(null, thread = new ServiceThread(this, "Streamed messages port monitor (" + this._socketAddress + ")"))) {
                    thread.setUncaughtExceptionHandler(Thread.currentThread().getUncaughtExceptionHandler());
                }
                return thread;
            }
        }

        private final class _MessagesHandler
        extends XMLElement
        implements XMLElement.Handler {
            _MessagesHandler() {
                super(MessagesPortServerModule.MESSAGES_ELEMENT);
            }

            public void addChild(XMLElement element) {
                if (this.getChildCount() >= MessagesPortServerModule.this.getBatchControl().getLimit()) {
                    this._queue();
                }
                super.addChild(element);
            }

            public XMLElement copy() {
                throw new UnsupportedOperationException();
            }

            public XMLElement onElementEnd(XMLElement element) throws XMLDocument.ParseException {
                this._queue();
                if (ValueConverter.convertToBoolean((String)ServiceMessages.ATTRIBUTE_TYPE.toString(), (String)"flush", (Optional)element.getAttributeValue("flush", Optional.empty()), (boolean)false)) {
                    _Receiver.this._flush(ForwarderMessages.FLUSH_REQUEST, true);
                }
                _Receiver.this._done();
                return element;
            }

            public XMLElement onElementStart(XMLElement element) throws XMLDocument.ParseException {
                _Receiver.this._checkAuthorized();
                _Receiver.this._keepReference(element);
                this.setAttribute("flush", element.getAttributeValue("flush", Optional.empty()));
                return this;
            }

            private void _queue() {
                if (this.getChildCount() > 0) {
                    Streamer.Input streamerInput = MessagesPortServerModule.this._getStreamer().newInput((XMLElement)this);
                    for (Serializable message : streamerInput) {
                        _Receiver.this._addMessage(message);
                    }
                    streamerInput.close();
                    this.disownChildren();
                }
            }
        }

        private final class _LoginHandler
        implements XMLElement.Handler {
            _LoginHandler() {
            }

            public XMLElement onElementEnd(XMLElement element) throws XMLDocument.ParseException {
                _Receiver.this._setClient(element.getAttributeValue(MessagesPortServerModule.CLIENT_ATTRIBUTE, Optional.empty()));
                Optional identifier = element.getAttributeValue(MessagesPortServerModule.USER_ATTRIBUTE, Optional.empty());
                Optional password = element.getAttributeValue(MessagesPortServerModule.PASSWORD_ATTRIBUTE, Optional.of(""));
                try {
                    if (!identifier.isPresent() || ((String)identifier.get()).trim().isEmpty()) {
                        String message = Message.format((Messages.Entry)ForwarderMessages.USER_ATTRIBUTE, (Object[])new Object[]{MessagesPortServerModule.USER_ATTRIBUTE});
                        _Receiver.this._getLogger().warn((Messages.Entry)BaseMessages.VERBATIM, new Object[]{message});
                        throw new AccessException(message);
                    }
                    String[] roles = MessagesPortServerModule.this._getRoles();
                    if (roles.length > 0) {
                        Optional identity = MessagesPortServerModule.this._getRealm().authenticate((String)identifier.get(), (Object)((String)password.get()).toCharArray());
                        _Receiver.this._setAuthorized(false);
                        if (!identity.isPresent()) {
                            String message = Message.format((Messages.Entry)ForwarderMessages.AUTHENTICATION_FAILED, (Object[])new Object[]{identifier.get()});
                            _Receiver.this._getLogger().warn((Messages.Entry)BaseMessages.VERBATIM, new Object[]{message});
                            throw new AccessException(message);
                        }
                        if (!((Identity)identity.get()).isInRoles(roles)) {
                            String message = Message.format((Messages.Entry)ForwarderMessages.NOT_AUTHORIZED, (Object[])new Object[]{identifier.get()});
                            _Receiver.this._getLogger().warn((Messages.Entry)BaseMessages.VERBATIM, new Object[]{message});
                            throw new AccessException(message);
                        }
                        _Receiver.this._setAuthorized(true);
                        _Receiver.this._getLogger().debug((Messages.Entry)ForwarderMessages.AUTHORIZED, new Object[]{identifier.get()});
                    }
                }
                catch (AccessException exception) {
                    throw new XMLDocument.ParseException((Throwable)exception);
                }
                _Receiver.this._done();
                return element;
            }

            public XMLElement onElementStart(XMLElement element) {
                _Receiver.this._keepReference(element);
                return element;
            }
        }

        private final class _FlushHandler
        implements XMLElement.Handler {
            _FlushHandler() {
            }

            public XMLElement onElementEnd(XMLElement element) {
                _Receiver.this._flush(ForwarderMessages.FLUSH_REQUEST, true);
                _Receiver.this._done();
                return element;
            }

            public XMLElement onElementStart(XMLElement element) throws XMLDocument.ParseException {
                _Receiver.this._checkAuthorized();
                _Receiver.this._keepReference(element);
                return element;
            }
        }
    }

    private final class _PortListener
    extends InputModule.AbstractInput
    implements ServiceThread.Target {
        private final Optional<ElapsedTime> _batchWait;
        private final String _comment;
        private final Logger _logger = Logger.getInstance(this.getClass());
        private List<Serializable> _messages;
        private final ServerSocket _serverSocket;
        private final SocketAddress _socketAddress;
        private final AtomicReference<ServiceThread> _thread = new AtomicReference();

        _PortListener(@Nonnull ServerSocket serverSocket, @Nonnull SocketAddress socketAddress, @Nonnull String comment, Optional<ElapsedTime> batchWait) {
            this._serverSocket = serverSocket;
            this._socketAddress = socketAddress;
            this._comment = comment;
            this._batchWait = batchWait;
        }

        @Override
        public void close() {
            ServiceThread thread;
            if (!this._serverSocket.isClosed() && (thread = (ServiceThread)this._thread.getAndSet(null)) != null) {
                MessagesPortServerModule.this.getThisLogger().debug((Messages.Entry)ServiceMessages.STOPPING_THREAD, new Object[]{thread.getName()});
                try {
                    this._serverSocket.close();
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
                Require.ignored((boolean)thread.join(this._logger, MessagesPortServerModule.this.getService().getJoinTimeout()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean commit() {
            List<Serializable> messages;
            List<Serializable> list = messages = this._messages;
            synchronized (list) {
                messages.clear();
                messages.notifyAll();
            }
            this._messages = null;
            return super.commit();
        }

        @Override
        public String getDisplayName() {
            return "Streamed messages port";
        }

        @Override
        public String getSourceName() {
            return this._socketAddress.toString();
        }

        @Override
        public Optional<Serializable[]> input(BatchControl batchControl) throws InterruptedException {
            while (true) {
                this._messages = MessagesPortServerModule.this._getQueue().take();
                if (!this._messages.isEmpty()) break;
                this.commit();
            }
            return Optional.of(this._messages.toArray(new Serializable[this._messages.size()]));
        }

        @Override
        public boolean isClosed() {
            return this._serverSocket.isClosed();
        }

        @Override
        public boolean isReliable() {
            return true;
        }

        @Override
        public boolean open() {
            ServiceThread thread = new ServiceThread(this, "XML input port (listener on " + this._serverSocket.getLocalSocketAddress() + ")");
            if (this._thread.compareAndSet(null, thread)) {
                MessagesPortServerModule.this.getThisLogger().debug((Messages.Entry)ServiceMessages.STARTING_THREAD, new Object[]{thread.getName()});
                thread.start();
            }
            return true;
        }

        @Override
        public void run() {
            this._logger.debug((Messages.Entry)ForwarderMessages.LISTENING_ON_PORT, new Object[]{this._serverSocket.getLocalSocketAddress(), this._comment});
            while (true) {
                Socket socket;
                try {
                    while ((socket = this._serverSocket.accept()) instanceof SSLSocket) {
                        try {
                            ((SSLSocket)socket).startHandshake();
                            socket.setKeepAlive(true);
                            break;
                        }
                        catch (IOException exception) {
                            this._logger.warn((Messages.Entry)ForwarderMessages.BAD_CONNECTION, new Object[]{this._serverSocket.getLocalSocketAddress(), exception.getMessage()});
                            socket.close();
                        }
                    }
                }
                catch (SocketException exception) {
                    break;
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
                this._logger.debug(() -> new Message((Messages.Entry)ForwarderMessages.CONNECTION_ACCEPTED, new Object[]{this._comment, socket.getRemoteSocketAddress()}));
                if (new _Receiver(this._batchWait)._open(socket)) continue;
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this._logger.debug(() -> new Message((Messages.Entry)ForwarderMessages.CONNECTION_CANCELLED, new Object[]{socket.getRemoteSocketAddress()}));
            }
        }

        @Override
        public boolean setUp(KeyedGroups moduleProperties) {
            if (!super.setUp(moduleProperties)) {
                return false;
            }
            try {
                this._serverSocket.bind(this._socketAddress);
            }
            catch (IOException exception) {
                this._logger.error((Messages.Entry)ServiceMessages.BIND_FAILED_, new Object[]{this._socketAddress, exception});
                return false;
            }
            if (!this._serverSocket.isBound()) {
                this._logger.error((Messages.Entry)ServiceMessages.BIND_FAILED, new Object[]{this._socketAddress});
                return false;
            }
            return true;
        }

        @Override
        public void tearDown() {
            this.close();
            super.tearDown();
        }
    }
}

