/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.input;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.forwarder.BatchControl;
import org.rvpf.forwarder.input.InputModule;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.som.SOMFactory;
import org.rvpf.service.som.SOMReceiver;

public final class SOMReceiverModule
extends InputModule {
    public static final String QUEUE_PROPERTIES = "queue";

    @Override
    protected boolean setUp(KeyedGroups moduleProperties) {
        this.setInput(new _Receiver());
        return super.setUp(moduleProperties);
    }

    private final class _Receiver
    extends InputModule.AbstractInput {
        private SOMReceiver _receiver;

        _Receiver() {
        }

        @Override
        public void close() {
            if (this._receiver != null) {
                this._receiver.close();
            }
        }

        @Override
        public boolean commit() {
            boolean success = this._receiver.commit();
            SOMReceiverModule.this.getTraces().commit();
            return success && super.commit();
        }

        @Override
        public String getDisplayName() {
            return "SOM receiver (" + (this._receiver.isServer() ? "server" : "client") + ")";
        }

        @Override
        public String getSourceName() {
            return this._receiver.getSOMName();
        }

        @Override
        public Optional<Serializable[]> input(BatchControl batchControl) {
            Serializable[] messageArray;
            int limit = batchControl.getLimit();
            Optional<ElapsedTime> wait = batchControl.getWait();
            LinkedList<Serializable[]> messageArrayList = new LinkedList<Serializable[]>();
            int count = 0;
            long timeout = -1L;
            while (true) {
                if ((messageArray = this._receiver.receive(limit - count, timeout)) == null) {
                    return Optional.empty();
                }
                if (messageArray.length == 0) break;
                messageArrayList.add(messageArray);
                if (!wait.isPresent() || (count += messageArray.length) >= limit) break;
                timeout = wait.get().toMillis();
            }
            if (messageArrayList.size() > 1) {
                Iterator iterator = messageArrayList.iterator();
                ArrayList<Object> messageList = new ArrayList<Object>(count);
                do {
                    messageList.addAll(Arrays.asList((Object[])iterator.next()));
                } while (iterator.hasNext());
                messageArray = messageList.toArray(new Serializable[messageList.size()]);
            } else {
                messageArray = (Serializable[])messageArrayList.get(0);
            }
            if (SOMReceiverModule.this.getTraces().isEnabled()) {
                for (Serializable message : messageArray) {
                    SOMReceiverModule.this.getTraces().add((Object)message);
                }
            }
            return Optional.of(messageArray);
        }

        @Override
        public boolean isClosed() {
            return this._receiver.isClosed();
        }

        @Override
        public boolean isReliable() {
            return !this._receiver.isRemote();
        }

        @Override
        public boolean open() {
            return this._receiver.open();
        }

        @Override
        public boolean rollback() {
            return this._receiver.rollback();
        }

        @Override
        public boolean setUp(KeyedGroups moduleProperties) {
            KeyedGroups queueProperties = moduleProperties.getGroup(SOMReceiverModule.QUEUE_PROPERTIES);
            if (queueProperties.isMissing()) {
                SOMReceiverModule.this.getThisLogger().error((Messages.Entry)ServiceMessages.MISSING_PROPERTIES, new Object[]{SOMReceiverModule.QUEUE_PROPERTIES});
                return false;
            }
            SOMFactory factory = new SOMFactory(SOMReceiverModule.this.getConfig());
            SOMFactory.Queue factoryQueue = factory.createQueue(queueProperties);
            this._receiver = factoryQueue.createReceiver(false);
            return this._receiver != null;
        }

        @Override
        public void tearDown() {
            if (this._receiver != null) {
                this._receiver.tearDown();
                this._receiver = null;
            }
        }
    }
}

