/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.input;

import java.io.Serializable;
import java.util.Optional;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.forwarder.BatchControl;
import org.rvpf.forwarder.input.InputModule;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.som.SOMFactory;
import org.rvpf.service.som.SOMSubscriber;

public final class SOMSubscriberModule
extends InputModule {
    public static final String TOPIC_PROPERTIES = "topic";

    @Override
    protected boolean setUp(KeyedGroups moduleProperties) {
        this.setInput(new _Subscriber());
        return super.setUp(moduleProperties);
    }

    private final class _Subscriber
    extends InputModule.AbstractInput {
        private SOMSubscriber _subscriber;

        _Subscriber() {
        }

        @Override
        public void close() {
            if (this._subscriber != null) {
                this._subscriber.close();
            }
        }

        @Override
        public boolean commit() {
            SOMSubscriberModule.this.getTraces().commit();
            return super.commit();
        }

        @Override
        public String getDisplayName() {
            return "SOM subscriber (" + (this._subscriber.isServer() ? "server" : "client") + ")";
        }

        @Override
        public String getSourceName() {
            return this._subscriber.getSOMName();
        }

        @Override
        public Optional<Serializable[]> input(BatchControl batchControl) throws InterruptedException {
            int limit = batchControl.getLimit();
            Serializable[] messageArray = this._subscriber.receive(limit, -1L);
            if (messageArray != null && SOMSubscriberModule.this.getTraces().isEnabled()) {
                for (Serializable message : messageArray) {
                    SOMSubscriberModule.this.getTraces().add((Object)message);
                }
            }
            return Optional.ofNullable(messageArray);
        }

        @Override
        public boolean isClosed() {
            return this._subscriber.isClosed();
        }

        @Override
        public boolean isReliable() {
            return !this._subscriber.isRemote();
        }

        @Override
        public boolean open() {
            return this._subscriber.open();
        }

        @Override
        public boolean setUp(KeyedGroups moduleProperties) {
            KeyedGroups topicProperties = moduleProperties.getGroup(SOMSubscriberModule.TOPIC_PROPERTIES);
            if (topicProperties.isMissing()) {
                SOMSubscriberModule.this.getThisLogger().error((Messages.Entry)ServiceMessages.MISSING_PROPERTIES, new Object[]{SOMSubscriberModule.TOPIC_PROPERTIES});
                return false;
            }
            SOMFactory factory = new SOMFactory(SOMSubscriberModule.this.getConfig());
            SOMFactory.Topic factoryTopic = factory.createTopic(topicProperties);
            this._subscriber = factoryTopic.createSubscriber(false);
            return this._subscriber != null;
        }

        @Override
        public void tearDown() {
            if (this._subscriber != null) {
                this._subscriber.tearDown();
                this._subscriber = null;
            }
        }
    }
}

