/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.input;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.DateTime;
import org.rvpf.base.Point;
import org.rvpf.base.UUID;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.rmi.ServiceClosedException;
import org.rvpf.base.store.Store;
import org.rvpf.base.store.StoreAccessException;
import org.rvpf.base.store.StoreValues;
import org.rvpf.base.store.StoreValuesQuery;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.value.PointValue;
import org.rvpf.document.loader.MetadataFilter;
import org.rvpf.forwarder.BatchControl;
import org.rvpf.forwarder.ForwarderMessages;
import org.rvpf.forwarder.input.InputModule;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.entity.StoreEntity;
import org.rvpf.service.ServiceMessages;
import org.rvpf.store.server.StoreMetadataFilter;
import org.rvpf.store.server.StoreServiceAppImpl;

@NotThreadSafe
public final class StoreRequestsModule
extends InputModule {
    public static final String CONTROL_DIR_PROPERTY = "control.dir";
    public static final String DELIVER_PROPERTY = "deliver";
    public static final String MARK_FILE_NAME = "Mark";
    public static final String NAME_PROPERTY = "name";
    public static final String NOTICES_PROPERTY = "notices";
    public static final String POINT_PROPERTY = "point";
    public static final String PULL_PROPERTY = "pull";
    public static final String STORE_PROPERTIES = "store";
    private File _controlDirectory;

    @Override
    public boolean needsMetadata() {
        return true;
    }

    @Override
    public boolean onMetadataRefreshed() {
        this.getInput().close();
        return true;
    }

    @Override
    protected boolean setUp(KeyedGroups moduleProperties) {
        KeyedGroups storeProperties = moduleProperties.getGroup(STORE_PROPERTIES);
        String storeName = (String)storeProperties.getString(NAME_PROPERTY, Optional.of("Store")).get();
        this.getThisLogger().info((Messages.Entry)ForwarderMessages.INPUT_STORE, new Object[]{storeName});
        StoreMetadataFilter filter = new StoreMetadataFilter(Optional.of(storeName), Optional.empty());
        if (!this.loadMetadata((MetadataFilter)filter)) {
            return false;
        }
        Optional storeEntity = filter.getStoreEntity();
        if (!storeEntity.isPresent()) {
            this.getThisLogger().error((Messages.Entry)ServiceMessages.STORE_NOT_FOUND, new Object[]{storeName});
            return false;
        }
        this.setInput(new _Input((StoreEntity)storeEntity.get()));
        return super.setUp(moduleProperties);
    }

    @Nonnull
    @CheckReturnValue
    Metadata _getMetadata() {
        return this.getMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @CheckReturnValue
    Optional<StoreValuesQuery.Mark> _readMark() throws IOException {
        BufferedReader reader;
        File file = new File(this._controlDirectory, MARK_FILE_NAME);
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        }
        catch (FileNotFoundException exception) {
            return Optional.empty();
        }
        try {
            DateTime stamp = DateTime.fromString((String)StoreRequestsModule._readMarkLine(reader));
            StoreValuesQuery.Builder queryBuilder = StoreValuesQuery.newBuilder();
            StoreValuesQuery query = queryBuilder.setPull(true).build();
            Optional<StoreValuesQuery.Mark> optional = Optional.of(query.newMark(Optional.empty(), stamp, 0));
            return optional;
        }
        finally {
            reader.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @CheckReturnValue
    boolean _setUpControlDir(@Nonnull String controlDirPath) {
        this._controlDirectory = new File(controlDirPath);
        if (this._controlDirectory.isDirectory()) {
            this.getThisLogger().info((Messages.Entry)ForwarderMessages.CONTROL_DIRECTORY, new Object[]{this._controlDirectory.getAbsolutePath()});
            return true;
        }
        if (this._controlDirectory.mkdirs()) {
            this.getThisLogger().info((Messages.Entry)ForwarderMessages.CONTROL_DIRECTORY_CREATED, new Object[]{this._controlDirectory});
            return true;
        }
        this.getThisLogger().error((Messages.Entry)ForwarderMessages.CONTROL_DIRECTORY_CREATE_FAILED, new Object[]{this._controlDirectory.getAbsolutePath()});
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _writeMark(@Nonnull StoreValuesQuery.Mark mark) throws IOException {
        File file = new File(this._controlDirectory, MARK_FILE_NAME);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            writer.write(mark.getStamp().toFullString());
            writer.newLine();
        }
    }

    private static String _readMarkLine(@Nonnull BufferedReader reader) throws IOException {
        String line;
        do {
            if ((line = reader.readLine()) != null) continue;
            throw new EOFException();
        } while ((line = line.trim()).length() <= 0 || line.startsWith("#"));
        return line;
    }

    private final class _Input
    extends InputModule.AbstractInput {
        private boolean _badConfig;
        private String _controlDirPath;
        private boolean _deliver;
        private Optional<StoreValuesQuery.Mark> _mark = Optional.empty();
        private boolean _notices;
        private String[] _pointsKeys;
        private boolean _pull;
        private _InputState _state;
        private volatile Store _store;
        private final StoreEntity _storeEntity;
        private UUID[] _subscribed;

        _Input(StoreEntity storeEntity) {
            this._storeEntity = storeEntity;
        }

        @Override
        public void close() {
            Store store = this._store;
            if (store != null) {
                this._store = null;
                if (this._subscribed != null) {
                    try {
                        store.unsubscribe(this._subscribed);
                    }
                    catch (StoreAccessException exception) {
                        StoreRequestsModule.this.getThisLogger().debug((Messages.Entry)ForwarderMessages.UNSUBSCRIBE_CLOSE_FAILED, new Object[]{exception});
                    }
                }
                store.close();
            }
        }

        @Override
        public boolean commit() {
            super.commit();
            StoreRequestsModule.this.getTraces().commit();
            if (this._mark.isPresent()) {
                try {
                    StoreRequestsModule.this._writeMark(this._mark.get());
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            }
            return super.commit();
        }

        @Override
        public String getDisplayName() {
            return "Pull Notifier input";
        }

        @Override
        public String getSourceName() {
            return this._storeEntity.getName().get();
        }

        @Override
        public Optional<Serializable[]> input(BatchControl batchControl) throws InterruptedException {
            StoreValues response;
            Store store = this._store;
            if (store == null) {
                return Optional.empty();
            }
            int limit = batchControl.getLimit();
            try {
                switch (this._state) {
                    case DELIVER: {
                        response = store.deliver(limit, -1L);
                        break;
                    }
                    case PULL_ALL: {
                        StoreValuesQuery.Builder queryBuilder;
                        StoreValuesQuery query;
                        if (this._mark.isPresent()) {
                            query = this._mark.get().createQuery();
                        } else {
                            queryBuilder = StoreValuesQuery.newBuilder();
                            queryBuilder.setPull(true);
                            queryBuilder.setLimit(limit);
                            query = queryBuilder.build();
                        }
                        response = store.pull(query, -1L);
                        if (response != null) {
                            this._mark = response.mark(limit);
                        }
                        break;
                    }
                    case PULL_FIRST: {
                        StoreValuesQuery.Builder queryBuilder;
                        StoreValuesQuery query;
                        if (this._mark.isPresent()) {
                            query = this._mark.get().createQuery();
                        } else {
                            queryBuilder = StoreValuesQuery.newBuilder();
                            queryBuilder.setPull(true);
                            queryBuilder.setLimit(limit);
                            query = queryBuilder.build();
                        }
                        response = store.pull(query, 0L);
                        if (response != null) {
                            if (response.isEmpty()) {
                                this._state = _InputState.DELIVER;
                                return this.input(batchControl);
                            }
                            this._mark = response.mark(limit);
                        }
                        break;
                    }
                    default: {
                        throw Require.failure();
                    }
                }
            }
            catch (StoreAccessException exception) {
                if (exception.getCause() instanceof ServiceClosedException) {
                    if (this._store != null) {
                        StoreRequestsModule.this.getThisLogger().warn((Messages.Entry)ServiceMessages.STORE_CLOSED, new Object[]{store});
                    }
                } else {
                    StoreRequestsModule.this.getThisLogger().warn((Throwable)exception, (Messages.Entry)ServiceMessages.STORE_ACCESS_FAILED, new Object[]{store, exception.getMessage()});
                }
                return Optional.empty();
            }
            ListIterator iterator = response.iterator();
            while (iterator.hasNext()) {
                PointValue pointValue = (PointValue)iterator.next();
                String pointName = (String)pointValue.getPointName().get();
                pointValue = pointValue.reset();
                pointValue.setPointName(pointName);
                iterator.set(pointValue);
                StoreRequestsModule.this.getTraces().add((Object)pointValue);
            }
            List responseValues = response.getPointValues();
            return Optional.of(responseValues.toArray(new PointValue[responseValues.size()]));
        }

        @Override
        public boolean isClosed() {
            return this._store == null;
        }

        @Override
        public boolean isReliable() {
            return this._badConfig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean open() {
            int i;
            UUID[] points;
            boolean notices;
            String[] pointKeys;
            block36: {
                if (!this._storeEntity.setUp(StoreRequestsModule.this._getMetadata())) {
                    return false;
                }
                Optional<? extends Store> store = this._storeEntity.getStore();
                if (!store.isPresent()) {
                    return false;
                }
                this._store = store.get();
                pointKeys = this._pointsKeys;
                notices = this._notices;
                try {
                    if (this._pull) {
                        if (!this._store.supportsPull()) {
                            return this._error(ForwarderMessages.PULL_NOT_SUPPORTED, this._storeEntity.getName());
                        }
                        if (this._deliver) {
                            if (!this._store.supportsDeliver()) {
                                return this._error(ForwarderMessages.DELIVER_NOT_SUPPORTED, this._storeEntity.getName());
                            }
                            notices |= pointKeys == null;
                            this._state = _InputState.PULL_FIRST;
                        } else {
                            this._state = _InputState.PULL_ALL;
                        }
                        break block36;
                    }
                    if (this._deliver) {
                        if (!this._store.supportsDeliver()) {
                            return this._error(ForwarderMessages.DELIVER_NOT_SUPPORTED, this._storeEntity.getName());
                        }
                        notices |= pointKeys == null;
                        this._state = _InputState.DELIVER;
                        break block36;
                    }
                    if (this._store.supportsPull()) {
                        if (this._controlDirPath == null) {
                            StoreRequestsModule.this.getThisLogger().error((Messages.Entry)BaseMessages.MISSING_PROPERTY, new Object[]{StoreRequestsModule.CONTROL_DIR_PROPERTY});
                            this._badConfig = true;
                            return false;
                        }
                        if (!StoreRequestsModule.this._setUpControlDir(this._controlDirPath)) {
                            this._badConfig = true;
                            return false;
                        }
                        try {
                            this._mark = StoreRequestsModule.this._readMark();
                        }
                        catch (IOException exception) {
                            return this._error(ForwarderMessages.MARK_READ_FAILED, exception.getMessage());
                        }
                        if (!this._mark.isPresent()) {
                            StoreRequestsModule.this.getThisLogger().info((Messages.Entry)ForwarderMessages.MARK_MISSING, new Object[0]);
                        }
                        if (this._store.supportsDeliver()) {
                            this._state = _InputState.PULL_FIRST;
                            notices |= pointKeys == null;
                        } else {
                            this._state = _InputState.PULL_ALL;
                        }
                        break block36;
                    }
                    if (this._store.supportsDeliver()) {
                        this._state = _InputState.DELIVER;
                        notices |= pointKeys == null;
                        break block36;
                    }
                    return this._error(ForwarderMessages.PULL_NOR_DELIVER, this._storeEntity.getName());
                }
                catch (StoreAccessException exception) {
                    return this._error(ServiceMessages.STORE_ACCESS_FAILED, this._store, exception.getMessage());
                }
            }
            if (notices) {
                Collection noticesFilter = StoreServiceAppImpl.makeNoticesFilter((Metadata)StoreRequestsModule.this._getMetadata());
                Iterator iterator = noticesFilter.iterator();
                points = new UUID[noticesFilter.size()];
                for (i = 0; i < points.length; ++i) {
                    points[i] = (UUID)((Point)iterator.next()).getUUID().get();
                }
            } else if (pointKeys != null) {
                points = new UUID[pointKeys.length];
                for (int i2 = 0; i2 < points.length; ++i2) {
                    Optional<Point> point = StoreRequestsModule.this._getMetadata().getPoint(pointKeys[i2]);
                    if (!point.isPresent()) continue;
                    points[i2] = (UUID)point.get().getUUID().get();
                }
            } else {
                points = null;
            }
            if (points != null) {
                block37: {
                    boolean success = false;
                    try {
                        if (this._store.supportsSubscribe()) {
                            success = this._store.subscribe(points);
                        } else {
                            this._error(ForwarderMessages.SUBSCRIBE_UNSUPPORTED, this._storeEntity.getName());
                        }
                    }
                    catch (StoreAccessException exception) {
                        StoreRequestsModule.this.getThisLogger().warn((Messages.Entry)ForwarderMessages.SUBSCRIBE_FAILED, new Object[]{exception});
                    }
                    finally {
                        if (success) break block37;
                        this._store.close();
                        this._store = null;
                        return false;
                    }
                }
                ArrayList<UUID> subscribed = new ArrayList<UUID>(points.length);
                for (i = 0; i < points.length; ++i) {
                    subscribed.add(points[i]);
                }
                this._subscribed = subscribed.toArray(new UUID[subscribed.size()]);
            } else {
                this._subscribed = null;
            }
            return true;
        }

        @Override
        public boolean setUp(KeyedGroups moduleProperties) {
            if (!super.setUp(moduleProperties)) {
                return false;
            }
            this._controlDirPath = moduleProperties.getString(StoreRequestsModule.CONTROL_DIR_PROPERTY).orElse(null);
            this._pull = moduleProperties.getBoolean(StoreRequestsModule.PULL_PROPERTY);
            this._deliver = moduleProperties.getBoolean(StoreRequestsModule.DELIVER_PROPERTY);
            this._notices = moduleProperties.getBoolean(StoreRequestsModule.NOTICES_PROPERTY);
            this._pointsKeys = moduleProperties.getStrings(StoreRequestsModule.POINT_PROPERTY);
            if (this._pointsKeys.length == 0) {
                this._pointsKeys = null;
            }
            return true;
        }

        private boolean _error(Messages.Entry entry, Object ... params) {
            StoreRequestsModule.this.getThisLogger().error(entry, params);
            this._badConfig = true;
            return false;
        }
    }

    private static enum _InputState {
        PULL_FIRST,
        DELIVER,
        PULL_ALL;

    }
}

