/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.output;

import java.io.Serializable;
import java.util.Optional;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.security.SecurityContext;
import org.rvpf.base.util.LoginInfo;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.xml.streamer.StreamedMessagesPortClient;
import org.rvpf.forwarder.ForwarderMessages;
import org.rvpf.forwarder.output.OutputModule;

public final class MessagesPortClientModule
extends OutputModule {
    public static final String ADDRESS_PROPERTY = "address";
    public static final String CLIENT_NAME_PROPERTY = "client.name";

    @Override
    protected boolean setUp(KeyedGroups moduleProperties) {
        this.setOutput(new _MessagesPortClient((String)moduleProperties.getString(CLIENT_NAME_PROPERTY).get()));
        return super.setUp(moduleProperties);
    }

    private final class _MessagesPortClient
    extends OutputModule.AbstractOutput {
        private String _addressString;
        private LoginInfo _loginInfo;
        private final StreamedMessagesPortClient _portClient;
        private SecurityContext _securityContext;

        _MessagesPortClient(String clientName) {
            this._portClient = new StreamedMessagesPortClient(clientName);
        }

        @Override
        public void close() {
            this._portClient.close();
        }

        @Override
        public String getDestinationName() {
            return this._addressString;
        }

        @Override
        public String getDisplayName() {
            return "Messages port client";
        }

        @Override
        public boolean isClosed() {
            return !this._portClient.isOpen();
        }

        @Override
        public boolean isOpen() {
            return this._portClient.isOpen();
        }

        @Override
        public boolean open() throws InterruptedException {
            try {
                this._portClient.open(this._addressString, Optional.of(this._securityContext));
            }
            catch (ServiceNotAvailableException exception) {
                return false;
            }
            try {
                this._portClient.login(this._loginInfo);
            }
            catch (ServiceNotAvailableException exception) {
                this.close();
                return false;
            }
            return true;
        }

        @Override
        public boolean output(Serializable[] messages) throws InterruptedException {
            for (Serializable message : messages) {
                this._portClient.addMessage(message);
            }
            try {
                this._portClient.sendMessages(true);
            }
            catch (ServiceNotAvailableException exception) {
                return false;
            }
            return true;
        }

        @Override
        public boolean setUp(KeyedGroups moduleProperties) {
            if (!super.setUp(moduleProperties)) {
                return false;
            }
            if (!this._portClient.setUp(Optional.of(MessagesPortClientModule.this.getConfigProperties()), Optional.empty())) {
                return false;
            }
            this._addressString = moduleProperties.getString(MessagesPortClientModule.ADDRESS_PROPERTY).orElse(null);
            if (this._addressString == null) {
                MessagesPortClientModule.this.getThisLogger().error((Messages.Entry)BaseMessages.MISSING_PROPERTY, new Object[]{MessagesPortClientModule.ADDRESS_PROPERTY});
                return false;
            }
            MessagesPortClientModule.this.getThisLogger().info((Messages.Entry)ForwarderMessages.ADDRESS, new Object[]{this._addressString});
            this._loginInfo = new LoginInfo(moduleProperties.getString("user"), moduleProperties.getPassword("password"));
            this._securityContext = new SecurityContext(MessagesPortClientModule.this.getThisLogger());
            return this._securityContext.setUp(MessagesPortClientModule.this.getConfigProperties(), moduleProperties.getGroup("security"));
        }

        @Override
        public void tearDown() {
            this.close();
            super.tearDown();
        }
    }
}

