/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.output;

import java.io.Serializable;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.logger.Message;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.forwarder.ForwarderMessages;
import org.rvpf.forwarder.ForwarderModule;

public abstract class OutputModule
extends ForwarderModule.Abstract {
    public static final int DEFAULT_BATCH_LIMIT = Integer.MAX_VALUE;
    private boolean _failed;
    private ModuleOutput _output;

    @CheckReturnValue
    public boolean commit() throws InterruptedException, ServiceNotAvailableException {
        if (!this._output.commit()) {
            return this._failed();
        }
        return true;
    }

    @CheckReturnValue
    public boolean output(@Nonnull Serializable[] messages) throws InterruptedException, ServiceNotAvailableException {
        if ((messages = this.filter(messages)).length > 0) {
            if (!this._output.isOpen()) {
                this.open(this._output);
            }
            if (!this._output.output(messages)) {
                return this._failed();
            }
            if (this.getThisLogger().isDebugEnabled()) {
                String to = this._output.getDestinationName();
                for (Serializable message : messages) {
                    this.getThisLogger().trace((Messages.Entry)ForwarderMessages.MESSAGE_TO, new Object[]{to, message});
                }
            }
        }
        return true;
    }

    @Override
    public void start() throws InterruptedException, ServiceNotAvailableException {
        if (this._output != null && this.isReliable()) {
            this.open(this._output);
        }
    }

    @Override
    public void stop() {
        if (this._output != null) {
            this._output.close();
        }
    }

    @Override
    public void tearDown() {
        if (this._output != null) {
            this._output.tearDown();
            this._output = null;
        }
        super.tearDown();
    }

    @Override
    protected int getDefaultBatchLimit() {
        return Integer.MAX_VALUE;
    }

    protected final boolean isAlone() {
        return this.getForwarderAppImpl().getOutputsSize() == 1;
    }

    protected final void open(@Nonnull ModuleOutput output) throws InterruptedException, ServiceNotAvailableException {
        boolean loggedFailed = false;
        while (true) {
            if (output.open()) {
                if (this.isReliable()) break;
                Message message = new Message((Messages.Entry)ForwarderMessages.CONNECTION_COMPLETED, new Object[]{output.getDestinationName()});
                if (this._failed) {
                    this.getThisLogger().info(message);
                    this._failed = false;
                    break;
                }
                this.getThisLogger().debug(message);
                break;
            }
            if (this.isReliable()) {
                this.getThisLogger().warn((Messages.Entry)ForwarderMessages.CONNECTION_FAILED, new Object[]{output.getDestinationName()});
                throw new ServiceNotAvailableException();
            }
            if (!loggedFailed) {
                this.getThisLogger().warn((Messages.Entry)ForwarderMessages.CONNECTION_FAILED_SLEEPING, new Object[]{output.getDestinationName()});
                loggedFailed = true;
                this._failed = true;
            }
            this.getService().snooze(this.getConnectionRetryDelay());
        }
    }

    protected final void setOutput(@Nonnull ModuleOutput output) {
        this._output = output;
    }

    @Override
    protected boolean setUp(KeyedGroups moduleProperties) {
        ModuleOutput output = this._output;
        if (output != null) {
            if (!output.setUp(moduleProperties)) {
                return false;
            }
            if (!this.getReliable().isPresent()) {
                this.setReliable(output.isReliable());
            }
        }
        return true;
    }

    private boolean _failed() throws ServiceNotAvailableException {
        this.getThisLogger().warn((Messages.Entry)ForwarderMessages.CONNECTION_LOST, new Object[0]);
        this._output.close();
        if (this.isReliable() && !this._output.isClosed()) {
            throw new ServiceNotAvailableException();
        }
        this._failed = true;
        return false;
    }

    protected static abstract class AbstractOutput
    extends ForwarderModule.Abstract.AbstractInputOutput
    implements ModuleOutput {
        protected AbstractOutput() {
        }
    }

    protected static interface ModuleOutput
    extends ForwarderModule.Abstract.ModuleInputOutput {
        @Nonnull
        @CheckReturnValue
        public String getDestinationName();

        @CheckReturnValue
        public boolean isOpen();

        @CheckReturnValue
        public boolean output(@Nonnull Serializable[] var1) throws InterruptedException;
    }
}

