/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.output;

import java.io.Serializable;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.forwarder.output.OutputModule;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.som.SOMFactory;
import org.rvpf.service.som.SOMPublisher;

public final class SOMPublisherModule
extends OutputModule {
    public static final String TOPIC_PROPERTIES = "topic";

    @Override
    protected boolean setUp(KeyedGroups moduleProperties) {
        this.setOutput(new _Publisher());
        return super.setUp(moduleProperties);
    }

    private final class _Publisher
    extends OutputModule.AbstractOutput {
        private boolean _open;
        private SOMPublisher _publisher;

        _Publisher() {
        }

        @Override
        public void close() {
            if (this._publisher != null) {
                this._publisher.close();
            }
            this._open = false;
        }

        @Override
        public boolean commit() {
            SOMPublisherModule.this.getTraces().commit();
            return super.commit();
        }

        @Override
        public String getDestinationName() {
            return this._publisher.getSOMName();
        }

        @Override
        public String getDisplayName() {
            return "SOM publisher (" + (this._publisher.isServer() ? "server" : "client") + ")";
        }

        @Override
        public boolean isClosed() {
            return this._publisher.isClosed();
        }

        @Override
        public boolean isOpen() {
            return this._open;
        }

        @Override
        public boolean isReliable() {
            return !this._publisher.isRemote();
        }

        @Override
        public boolean open() throws InterruptedException {
            this._open = this._publisher.open();
            return this.isOpen();
        }

        @Override
        public boolean output(Serializable[] messages) throws InterruptedException {
            if (!this._publisher.send(messages)) {
                SOMPublisherModule.this.getThisLogger().warn((Messages.Entry)ServiceMessages.SERVICE_CLOSED, new Object[0]);
                return false;
            }
            if (SOMPublisherModule.this.getTraces().isEnabled()) {
                for (Serializable message : messages) {
                    SOMPublisherModule.this.getTraces().add((Object)message);
                }
            }
            return true;
        }

        @Override
        public boolean setUp(KeyedGroups moduleProperties) {
            if (!super.setUp(moduleProperties)) {
                return false;
            }
            KeyedGroups topicProperties = moduleProperties.getGroup(SOMPublisherModule.TOPIC_PROPERTIES);
            if (topicProperties.isMissing()) {
                SOMPublisherModule.this.getThisLogger().error((Messages.Entry)ServiceMessages.MISSING_PROPERTIES, new Object[]{SOMPublisherModule.TOPIC_PROPERTIES});
                return false;
            }
            SOMFactory factory = new SOMFactory(SOMPublisherModule.this.getConfig());
            SOMFactory.Topic factoryTopic = factory.createTopic(topicProperties);
            this._publisher = factoryTopic.createPublisher(false);
            return this._publisher != null;
        }

        @Override
        public void tearDown() {
            if (this._publisher != null) {
                this._publisher.tearDown();
                this._publisher = null;
            }
            super.tearDown();
        }
    }
}

