/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.output;

import java.io.Serializable;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.forwarder.output.OutputModule;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.som.SOMFactory;
import org.rvpf.service.som.SOMSender;

public final class SOMSenderModule
extends OutputModule {
    public static final String QUEUE_PROPERTIES = "queue";

    @Override
    protected boolean setUp(KeyedGroups moduleProperties) {
        this.setOutput(new _Sender());
        return super.setUp(moduleProperties);
    }

    private final class _Sender
    extends OutputModule.AbstractOutput {
        private boolean _open;
        private SOMSender _sender;

        _Sender() {
        }

        @Override
        public void close() {
            if (this._sender != null) {
                this._sender.close();
            }
            this._open = false;
        }

        @Override
        public boolean commit() {
            if (!SOMSenderModule.this.isAlone() && !this._sender.commit()) {
                SOMSenderModule.this.getThisLogger().warn((Messages.Entry)ServiceMessages.SERVICE_CLOSED, new Object[0]);
                return false;
            }
            SOMSenderModule.this.getTraces().commit();
            return super.commit();
        }

        @Override
        public String getDestinationName() {
            return this._sender.getSOMName();
        }

        @Override
        public String getDisplayName() {
            return "SOM sender (" + (this._sender.isServer() ? "server" : "client") + ")";
        }

        @Override
        public boolean isClosed() {
            return this._sender.isClosed();
        }

        @Override
        public boolean isOpen() {
            return this._open;
        }

        @Override
        public boolean isReliable() {
            return !this._sender.isRemote();
        }

        @Override
        public boolean open() {
            this._open = this._sender.open();
            return this.isOpen();
        }

        @Override
        public boolean output(Serializable[] messages) {
            if (!this._sender.send(messages, SOMSenderModule.this.isAlone())) {
                SOMSenderModule.this.getThisLogger().warn((Messages.Entry)ServiceMessages.SERVICE_CLOSED, new Object[0]);
                return false;
            }
            if (SOMSenderModule.this.getTraces().isEnabled()) {
                for (Serializable message : messages) {
                    SOMSenderModule.this.getTraces().add((Object)message);
                }
            }
            return true;
        }

        @Override
        public boolean setUp(KeyedGroups moduleProperties) {
            if (!super.setUp(moduleProperties)) {
                return false;
            }
            KeyedGroups queueProperties = moduleProperties.getGroup(SOMSenderModule.QUEUE_PROPERTIES);
            if (queueProperties.isMissing()) {
                SOMSenderModule.this.getThisLogger().error((Messages.Entry)ServiceMessages.MISSING_PROPERTIES_IN, new Object[]{SOMSenderModule.QUEUE_PROPERTIES, moduleProperties.getName().orElse(null)});
                return false;
            }
            SOMFactory factory = new SOMFactory(SOMSenderModule.this.getConfig());
            SOMFactory.Queue factoryQueue = factory.createQueue(queueProperties);
            this._sender = factoryQueue.createSender(false);
            return this._sender != null;
        }

        @Override
        public void tearDown() {
            if (this._sender != null) {
                this._sender.tearDown();
                this._sender = null;
            }
            super.tearDown();
        }
    }
}

