/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.forwarder.output;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.rmi.RegistryEntry;
import org.rvpf.base.rmi.SessionConnectFailedException;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.store.StoreSessionProxy;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.value.PointValue;
import org.rvpf.forwarder.output.OutputModule;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.rmi.ServiceRegistry;

public class StoreUpdaterModule
extends OutputModule {
    @Override
    protected boolean setUp(KeyedGroups moduleProperties) {
        this.setOutput(new _StoreUpdater());
        return super.setUp(moduleProperties);
    }

    private final class _StoreUpdater
    extends OutputModule.AbstractOutput {
        private volatile StoreSessionProxy _sessionProxy;
        private final List<PointValue> _updates = new LinkedList<PointValue>();

        _StoreUpdater() {
        }

        @Override
        public void close() {
            if (this._sessionProxy != null) {
                this._sessionProxy.disconnect();
            }
        }

        @Override
        public boolean commit() {
            if (!this._updates.isEmpty()) {
                try {
                    boolean success = this._sessionProxy.updateAndCheck(this._updates, StoreUpdaterModule.this.getThisLogger());
                    this._updates.clear();
                    if (!success) {
                        return false;
                    }
                }
                catch (SessionException exception) {
                    throw new RuntimeException(exception);
                }
            }
            return super.commit();
        }

        @Override
        public String getDestinationName() {
            return this._sessionProxy.getServerName();
        }

        @Override
        public String getDisplayName() {
            return "Store updater";
        }

        @Override
        public boolean isClosed() {
            StoreSessionProxy sessionProxy = this._sessionProxy;
            return sessionProxy == null || !sessionProxy.isConnected();
        }

        @Override
        public boolean isOpen() {
            return this._sessionProxy.isConnected();
        }

        @Override
        public boolean isReliable() {
            return !this._sessionProxy.isRemote();
        }

        @Override
        public boolean open() throws InterruptedException {
            try {
                this._sessionProxy.connect();
            }
            catch (SessionConnectFailedException exception) {
                StoreUpdaterModule.this.getThisLogger().error((Messages.Entry)ServiceMessages.CONNECTION_FAILED, new Object[]{this.getDestinationName(), exception.getMessage()});
                return false;
            }
            return true;
        }

        @Override
        public boolean output(Serializable[] messages) {
            for (Serializable message : messages) {
                if (!(message instanceof PointValue)) continue;
                this._updates.add((PointValue)message);
            }
            return true;
        }

        @Override
        public boolean setUp(KeyedGroups moduleProperties) {
            Optional password;
            Optional user;
            if (!super.setUp(moduleProperties)) {
                return false;
            }
            KeyedGroups storeProperties = moduleProperties.getGroup("store");
            KeyedGroups securityProperties = storeProperties.getGroup("security");
            if (securityProperties.isMissing()) {
                securityProperties = moduleProperties.getGroup("security");
            }
            if ((user = storeProperties.getString("user")).isPresent()) {
                password = storeProperties.getPassword("password");
            } else {
                user = moduleProperties.getString("user");
                password = moduleProperties.getPassword("password");
            }
            RegistryEntry registryEntry = RegistryEntry.newBuilder().setBinding(storeProperties.getString("binding")).setName(storeProperties.getString("name")).setDefaultName("Store").setDefaultRegistryAddress(ServiceRegistry.getRegistryAddress()).setDefaultRegistryPort(ServiceRegistry.getRegistryPort()).build();
            this._sessionProxy = (StoreSessionProxy)StoreSessionProxy.newBuilder().setRegistryEntry(registryEntry).setConfigProperties(StoreUpdaterModule.this.getConfigProperties()).setSecurityProperties(securityProperties).setLoginUser(user).setLoginPassword(password).setClientName(StoreUpdaterModule.this.getConfig().getServiceName()).setClientLogger(StoreUpdaterModule.this.getThisLogger()).build();
            if (this._sessionProxy == null) {
                return false;
            }
            if (this._sessionProxy.isRemote()) {
                StoreUpdaterModule.this.getThisLogger().warn((Messages.Entry)ServiceMessages.REMOTE_SERVICE_WARNING, new Object[]{this._sessionProxy.getServerURI()});
            }
            return true;
        }

        @Override
        public void tearDown() {
            this.close();
            this._sessionProxy = null;
            super.tearDown();
        }
    }
}

