/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.clock;

import java.io.Serializable;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.NormalizedValue;
import org.rvpf.base.value.PointValue;
import org.rvpf.content.AbstractContent;
import org.rvpf.service.ServiceMessages;

public class ClockContent
extends AbstractContent {
    @Override
    public final Short decode(PointValue pointValue) {
        short millis;
        Short shortValue = this._getShort(pointValue);
        short s = millis = shortValue != null ? shortValue : (short)0;
        if (millis < 0 || 999 < millis) {
            this.getThisLogger().warn(ServiceMessages.UNEXPECTED_CLOCK_VALUE, pointValue);
            shortValue = 0;
        }
        return shortValue;
    }

    @Override
    public final Short denormalize(NormalizedValue normalizedValue) {
        Short shortValue;
        Serializable value = normalizedValue.getValue();
        if (value != null) {
            long millis = (Long)value;
            Require.equal(normalizedValue.getStamp().toMillis(), millis);
            shortValue = (short)(millis % 1000L);
        } else {
            shortValue = null;
        }
        return shortValue;
    }

    @Override
    public final Long normalize(PointValue pointValue) {
        Long millis;
        Short shortValue = this._getShort(pointValue);
        if (shortValue != null) {
            long stampSeconds = pointValue.getStamp().toMillis() / 1000L;
            millis = stampSeconds * 1000L + (long)shortValue.shortValue();
        } else {
            millis = null;
        }
        return millis;
    }

    private Short _getShort(PointValue pointValue) {
        Serializable value = pointValue.getValue();
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Double) {
            return (short)Math.round((Double)value);
        }
        if (value instanceof Float) {
            return (short)Math.round(((Float)value).floatValue());
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            try {
                return Short.decode((String)((Object)value));
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (value instanceof Boolean) {
            return (short)((Boolean)value != false ? 1 : 0);
        }
        if (value != null) {
            this.warnBadValue(pointValue);
        }
        return null;
    }
}

