/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.clock;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.tool.Require;
import org.rvpf.base.xml.XMLElement;
import org.rvpf.document.loader.MetadataFilter;
import org.rvpf.metadata.entity.OriginEntity;
import org.rvpf.metadata.entity.PointEntity;

public final class ClockMetadataFilter
extends MetadataFilter {
    private static final String _CLOCK_IDENT = "Clock";
    private OriginEntity _originEntity;
    private final String _originName;

    ClockMetadataFilter(@Nonnull String originName) {
        super(false);
        this._originName = Require.notNull(originName);
    }

    @Override
    public boolean areContentsNeeded() {
        return true;
    }

    @Override
    public boolean areOriginsFiltered() {
        return true;
    }

    @Override
    public boolean areOriginsNeeded() {
        return true;
    }

    @Override
    public boolean areStoresNeeded() {
        return true;
    }

    @Override
    public Optional<String> getClientIdent() {
        return Optional.of(_CLOCK_IDENT);
    }

    @Nonnull
    @CheckReturnValue
    public Optional<OriginEntity> getOriginEntity() {
        return Optional.ofNullable(this._originEntity);
    }

    @Nonnull
    @CheckReturnValue
    public String getOriginName() {
        return this._originName;
    }

    @Override
    public boolean isOriginNeeded(OriginEntity originEntity) {
        boolean needed;
        boolean bl = needed = this._originEntity == null && this._originName.equalsIgnoreCase(originEntity.getName().orElse(null));
        if (needed) {
            this._originEntity = originEntity;
        }
        return needed;
    }

    @Override
    public boolean isPointNeeded(PointEntity pointEntity) {
        return pointEntity.getOriginEntity().orElse(null) == this._originEntity;
    }

    @Override
    public void reset() {
        this._originEntity = null;
        super.reset();
    }

    @Override
    protected void includeOriginsXML(XMLElement root) {
        root.addChild("origins").setAttribute("origin", this.getOriginName());
    }
}

