/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.clock;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.rvpf.base.DateTime;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.Point;
import org.rvpf.base.alert.Event;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.rmi.ServiceClosedException;
import org.rvpf.base.store.StoreValues;
import org.rvpf.base.store.StoreValuesQuery;
import org.rvpf.base.sync.CrontabSync;
import org.rvpf.base.sync.Sync;
import org.rvpf.base.tool.Require;
import org.rvpf.base.tool.Traces;
import org.rvpf.base.util.Schedule;
import org.rvpf.base.value.NormalizedValue;
import org.rvpf.base.value.PointValue;
import org.rvpf.clock.ClockContent;
import org.rvpf.clock.ClockMetadataFilter;
import org.rvpf.config.Config;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.entity.OriginEntity;
import org.rvpf.metadata.entity.PointEntity;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.ServiceThread;
import org.rvpf.service.metadata.MetadataService;
import org.rvpf.service.metadata.app.MetadataServiceAppImpl;

public final class ClockServiceAppImpl
extends MetadataServiceAppImpl
implements ServiceThread.Target {
    public static final String DEFAULT_NAME = "Clock";
    public static final String GENERATED_TRACES = "generated";
    public static final String MIDNIGHT_ENABLED_PROPERTY = "clock.midnight.enabled";
    public static final String NAME_PROPERTY = "clock.name";
    private String _entityName;
    private boolean _midnightEnabled;
    private OriginEntity _origin;
    private boolean _reconnectNeeded;
    private final Schedule<Schedule.PointEvent> _schedule = new Schedule(false);
    private final AtomicReference<ServiceThread> _thread = new AtomicReference();
    private final Traces _traces = new Traces();

    @Override
    public Optional<String> getEntityName() {
        return Optional.of(this._entityName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onEvent(Event event) {
        if ("Watchdog".equalsIgnoreCase(event.getName())) {
            Schedule<Schedule.PointEvent> schedule = this._schedule;
            synchronized (schedule) {
                this._schedule.notifyAll();
            }
        }
        return super.onEvent(event);
    }

    @Override
    public boolean onNewMetadata(Metadata metadata) {
        int count = 0;
        for (Point point : metadata.getPointsCollection()) {
            if (!((PointEntity)point).setUp(metadata)) {
                return false;
            }
            if (!(point.getContent().orElse(null) instanceof ClockContent)) {
                this.getThisLogger().error(ServiceMessages.CLOCK_CONTENT_CLASS, point);
                return false;
            }
            if (!point.getSync().isPresent()) {
                this.getThisLogger().error(ServiceMessages.CLOCK_POINT_NEEDS_SYNC, point);
                return false;
            }
            ++count;
        }
        this.getThisLogger().info(ServiceMessages.CLOCK_SET_UP, String.valueOf(count), count);
        metadata.cleanUp();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServicesNotReady() {
        Schedule<Schedule.PointEvent> schedule = this._schedule;
        synchronized (schedule) {
            this._schedule.clear();
            this._reconnectNeeded = true;
            this._schedule.notifyAll();
        }
    }

    @Override
    public void run() throws InterruptedException {
        try {
            Schedule<Schedule.PointEvent> schedule = this._schedule;
            synchronized (schedule) {
                while (true) {
                    if (this._schedule.isEmpty()) {
                        if (this._reconnectNeeded) {
                            this.getService().resetPointsStore();
                            this._reconnectNeeded = false;
                        }
                        this._setUpEvents();
                    }
                    long delay = this._processEvents();
                    this._traces.commit();
                    this._schedule.wait(delay);
                }
            }
        }
        catch (ServiceClosedException serviceClosedException) {
        }
        catch (ServiceNotAvailableException exception) {
            this.onServiceNotAvailableException(exception);
        }
    }

    @Override
    public boolean setUp(MetadataService service) {
        if (!super.setUp(service)) {
            return false;
        }
        Config config = service.getConfig();
        this._entityName = config.getStringValue(NAME_PROPERTY, Optional.of(DEFAULT_NAME)).orElse(null);
        this.getThisLogger().info(ServiceMessages.ORIGIN, this._entityName);
        ClockMetadataFilter filter = new ClockMetadataFilter(this._entityName);
        if (!this.loadMetadata(filter)) {
            return false;
        }
        Optional<OriginEntity> origin = filter.getOriginEntity();
        if (!origin.isPresent()) {
            this.getThisLogger().error(ServiceMessages.ORIGIN_NOT_FOUND, this._entityName);
            return false;
        }
        this._origin = origin.get();
        service.setSourceUUID(this._origin.getUUID().get());
        service.monitorStores();
        this._midnightEnabled = config.getBooleanValue(MIDNIGHT_ENABLED_PROPERTY);
        if (this._midnightEnabled) {
            this.getThisLogger().info(ServiceMessages.MIDNIGHT_EVENT_ENABLED, new Object[0]);
        }
        return this._traces.setUp(this.getDataDir(), this.getConfigProperties().getGroup("traces"), this.getSourceUUID(), Optional.of(GENERATED_TRACES));
    }

    @Override
    public void start() {
        ServiceThread thread = new ServiceThread(this, "Clock service");
        if (this._thread.compareAndSet(null, thread)) {
            this.getThisLogger().debug(ServiceMessages.STARTING_THREAD, thread.getName());
            thread.start();
        }
    }

    @Override
    public void stop() {
        ServiceThread thread = this._thread.getAndSet(null);
        if (thread != null) {
            this.getThisLogger().debug(ServiceMessages.STOPPING_THREAD, thread.getName());
            Require.ignored(thread.interruptAndJoin(this.getThisLogger(), this.getJoinTimeout()));
            for (Point point : this.getMetadata().getPointsCollection()) {
                ((PointEntity)point).close();
            }
        }
    }

    @Override
    public void tearDown() {
        this._traces.tearDown();
        this._schedule.clear();
        super.tearDown();
    }

    private long _processEvents() throws InterruptedException, ServiceNotAvailableException {
        long delay;
        while ((delay = this._schedule.getDelay()) <= 0L) {
            Schedule.PointEvent event = (Schedule.PointEvent)this._schedule.next();
            Optional<Point> point = event.getPoint();
            DateTime stamp = event.getStamp();
            if (point.isPresent()) {
                PointValue pointValue = new NormalizedValue(point.get(), Optional.of(stamp), null, (Serializable)Long.valueOf(stamp.toMillis())).encoded();
                if (pointValue.updateStore()) {
                    this._traces.add(pointValue);
                }
            } else {
                this.getService().sendEvent("Midnight", Optional.empty());
            }
            this._schedule.advance();
        }
        return delay;
    }

    private void _setUpEvent(Point point) throws InterruptedException, ServiceNotAvailableException {
        StoreValuesQuery.Builder queryBuilder = StoreValuesQuery.newBuilder().setPoint(point);
        StoreValues response = queryBuilder.build().getResponse();
        if (response.isSuccess()) {
            Schedule.PointEvent event;
            Sync pointSync = point.getSync().get();
            Optional<PointValue> pointValue = response.getPointValue();
            if (!pointValue.isPresent() || pointValue.get().getValue() == null) {
                DateTime stamp = DateTime.now().floored(ElapsedTime.MINUTE);
                event = new Schedule.PointEvent(Optional.of(point), stamp, pointSync);
                this.getThisLogger().info(ServiceMessages.CLOCK_POINT_NEW, point, event.getStamp());
            } else {
                DateTime stamp = DateTime.fromMillis((Long)pointValue.get().normalized().getValue());
                event = new Schedule.PointEvent(Optional.of(point), pointSync.getNextStamp(stamp).get(), pointSync);
            }
            this._schedule.add(event);
        } else {
            this.getThisLogger().warn(ServiceMessages.STORE_REJECTED_QUERY_ON, point, response.getException().get().getMessage());
        }
    }

    private void _setUpEvents() throws InterruptedException, ServiceNotAvailableException {
        if (this._midnightEnabled) {
            this._schedule.add(new Schedule.PointEvent(Optional.empty(), DateTime.now(), new CrontabSync("0 0 * * *")));
        }
        for (Point point : this.getMetadata().getPointsCollection()) {
            this._setUpEvent(point);
        }
        if (this._schedule.isEmpty()) {
            this._schedule.add(new Schedule.PointEvent(Optional.empty(), DateTime.END_OF_TIME, new CrontabSync("0 0 * * *")));
        }
    }
}

