/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.ClassDef;
import org.rvpf.base.DateTime;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.Entity;
import org.rvpf.base.Params;
import org.rvpf.base.UUID;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.Require;
import org.rvpf.base.tool.ValueConverter;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.config.ConfigProperties;
import org.rvpf.config.UndefinedEntityException;
import org.rvpf.config.entity.ClassDefEntity;
import org.rvpf.config.entity.ClassLibEntity;
import org.rvpf.document.loader.DocumentPropertiesMap;
import org.rvpf.document.loader.DocumentStream;
import org.rvpf.service.Service;
import org.rvpf.service.ServiceClassLoader;
import org.rvpf.service.ServiceContext;
import org.rvpf.service.ServiceMessages;

@NotThreadSafe
public class Config {
    public static final String CACHE_DIR_PROPERTY = "cache.dir";
    public static final String CONFIG_DIR_PROPERTY = "config.dir";
    public static final URI CWD_URI = new File(System.getProperty("user.dir")).toURI();
    public static final String DEFAULT_CACHE_DIR = "cache";
    public static final String DEFAULT_SERVICE_DATA_DIR = "data";
    public static final String RVPF_PROPERTIES = "rvpf.properties";
    public static final String SERVICE_DATA_DIR_PROPERTY = "service.data.dir";
    public static final String SERVICE_FILENAME = "service";
    public static final String SUBSTITUTION_DEFERRED_PROPERTY = "substitution.deferred";
    public static final String SUBSTITUTION_ENABLED_PROPERTY = "substitution.enabled";
    public static final String SYSTEM_PROPERTY_PREFIX = "rvpf.";
    public static final String UUID_FILENAME = "UUID";
    private final Map<String, ClassDefEntity> _classDefsByName = new HashMap<String, ClassDefEntity>();
    private final Map<String, ClassLibEntity> _classLibsByName = new HashMap<String, ClassLibEntity>();
    private volatile ServiceClassLoader _classLoader;
    private volatile File _dataDir;
    private final Logger _logger = Logger.getInstance(this.getClass());
    private final ConfigProperties _properties;
    private String _rootName;
    private Service _service;
    private final Map<String, ServiceContext> _serviceContexts = new HashMap<String, ServiceContext>();
    private final String _serviceName;
    private final Map<String, ServiceContext> _servicesByAlias = new HashMap<String, ServiceContext>();
    private Optional<DateTime> _stamp = Optional.empty();
    private _State _state = new _State();
    private URL _url;

    public Config(@Nonnull String serviceName) {
        this(serviceName, new ConfigProperties(ServiceMessages.CONFIG_PROPERTIES_TYPE, Optional.of(serviceName)));
        this.fetchSystemProperties();
        this._fetchResourceProperties();
    }

    public Config(@Nonnull String serviceName, @Nonnull ConfigProperties properties) {
        this._serviceName = Require.notNull(serviceName);
        this._properties = Require.notNull(properties);
    }

    @Nonnull
    @CheckReturnValue
    public static final File dataDir(@Nonnull Optional<File> parentDir, @Nonnull KeyedGroups serviceProperties, @Nonnull String dataDirProperty, @Nonnull String defaultDirName) {
        Path path;
        String pathString = serviceProperties.getString(dataDirProperty, Optional.of(defaultDirName)).get();
        try {
            path = Paths.get(pathString, new String[0]);
        }
        catch (InvalidPathException exception) {
            Logger.getInstance(Config.class).warn(ServiceMessages.INVALID_PATH_IN, pathString, dataDirProperty);
            path = Paths.get(defaultDirName, new String[0]);
        }
        if (parentDir.isPresent()) {
            path = parentDir.get().toPath().resolve(path);
        }
        return path.toFile();
    }

    public final void addClassDefEntity(@Nonnull ClassDefEntity classDef) {
        Optional<String> name = classDef.getName();
        Require.success(name.isPresent());
        this._classDefsByName.put(name.get().toUpperCase(Locale.ROOT), classDef);
    }

    public final void addClassLibEntity(@Nonnull ClassLibEntity classLib) {
        Optional<String> name = classLib.getName();
        if (name.isPresent()) {
            this._classLibsByName.put(name.get().toUpperCase(Locale.ROOT), classLib);
        }
    }

    public final void addServiceContext(@Nonnull ServiceContext serviceContext) {
        Set<String> aliases = serviceContext.getServiceAliases();
        String serviceKey = serviceContext.getServiceName().toUpperCase(Locale.ROOT);
        ServiceContext registeredContext = this._serviceContexts.get(serviceKey);
        if (registeredContext == null) {
            this._serviceContexts.put(serviceKey, serviceContext);
            if (this._servicesByAlias.containsKey(serviceKey)) {
                this.getThisLogger().warn(ServiceMessages.SERVICE_NAME_HIDES_ALIAS, serviceContext.getServiceName());
            }
        } else {
            registeredContext.add(serviceContext);
        }
        if (aliases != null) {
            for (String alias : aliases) {
                String aliasKey = alias.toUpperCase(Locale.ROOT);
                registeredContext = this._servicesByAlias.get(aliasKey);
                if (registeredContext != null) {
                    if (!registeredContext.getServiceName().equalsIgnoreCase(serviceContext.getServiceName())) continue;
                    this.getThisLogger().warn(ServiceMessages.SERVICE_ALIAS_COLLIDES, alias);
                    continue;
                }
                if (this._serviceContexts.get(aliasKey) != null) {
                    this.getThisLogger().warn(ServiceMessages.SERVICE_ALIAS_HIDDEN, alias);
                }
                this._servicesByAlias.put(aliasKey, serviceContext);
            }
        }
    }

    @CheckReturnValue
    public final boolean containsProperties(@Nonnull String key) {
        return this._properties.containsGroupKey(key);
    }

    @CheckReturnValue
    public final boolean containsProperty(@Nonnull String key) {
        return this._properties.containsValueKey(key);
    }

    @Nullable
    @CheckReturnValue
    public final URL createURL(@Nonnull String from, @Nonnull Optional<URL> context) {
        URL fromURL;
        try {
            if (context.isPresent()) {
                fromURL = null;
            } else {
                Optional<String> dir = this.getConfigDir();
                if (dir.isPresent()) {
                    context = Optional.of(new File(dir.get()).toURI().toURL());
                    fromURL = null;
                } else {
                    fromURL = Thread.currentThread().getContextClassLoader().getResource(from);
                    if (fromURL == null) {
                        context = Optional.of(CWD_URI.toURL());
                    }
                }
            }
            if (fromURL == null) {
                fromURL = new URL(context.get(), from);
            }
        }
        catch (MalformedURLException exception) {
            this.getThisLogger().error(ServiceMessages.BAD_URL, from);
            fromURL = null;
        }
        return fromURL;
    }

    public final void fetchSystemProperties() {
        Require.notPresent(this._properties.getOverrider());
        ConfigProperties systemProperties = new ConfigProperties(ServiceMessages.SYSTEM_PROPERTIES_TYPE);
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String name = (String)entry.getKey();
            if (!name.startsWith(SYSTEM_PROPERTY_PREFIX)) continue;
            systemProperties.add(name.substring(SYSTEM_PROPERTY_PREFIX.length()), entry.getValue());
        }
        this._properties.setOverrider(systemProperties);
    }

    @CheckReturnValue
    public final boolean getBooleanValue(@Nonnull String key) {
        return this._properties.getBoolean(key, false);
    }

    @CheckReturnValue
    public final boolean getBooleanValue(@Nonnull String key, boolean defaultValue) {
        return this._properties.getBoolean(key, defaultValue);
    }

    @Nullable
    @CheckReturnValue
    public final File getCacheDir(@Nonnull String section, @Nonnull Optional<UUID> uuid, @Nonnull Optional<String> ident) {
        File cacheRoot = Config.dataDir(Optional.of(this.getDataDir()), this.getProperties(), CACHE_DIR_PROPERTY, DEFAULT_CACHE_DIR);
        File cacheDir = new File(cacheRoot, section);
        if (uuid.isPresent()) {
            cacheDir = new File(cacheDir, uuid.get().toName());
        }
        String cacheDirPath = cacheDir.getAbsolutePath();
        this.getThisLogger().debug(ServiceMessages.CACHE_DIR, cacheDirPath);
        if (!cacheDir.isDirectory()) {
            if (cacheDir.mkdirs()) {
                String serviceName = this.getServiceName();
                try {
                    if (uuid.isPresent()) {
                        Config.createFile(cacheDir, UUID_FILENAME, uuid.get().toString());
                    }
                    if (ident.isPresent()) {
                        Config.createFile(cacheDir, ident.get(), serviceName);
                    } else if (!serviceName.isEmpty()) {
                        Config.createFile(cacheDir, SERVICE_FILENAME, serviceName);
                    }
                    this.getThisLogger().info(ServiceMessages.CACHE_CREATED, cacheDirPath);
                }
                catch (IOException exception) {
                    this.getThisLogger().warn(ServiceMessages.CACHE_INIT_FAILED, cacheDirPath, exception.getMessage());
                    cacheDir = null;
                }
            } else {
                this.getThisLogger().warn(ServiceMessages.CACHE_CREATION_FAILED, cacheDirPath);
                cacheDir = null;
            }
        }
        return cacheDir;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<? extends ClassDef> getClassDef(@Nonnull String key, @Nonnull Optional<ClassDef> defaultClassDef) {
        Optional<ClassDef> classDef = this.getClassDefEntity(key);
        if (!classDef.isPresent()) {
            Object object = this._properties.getObject(key).orElse(null);
            if (object instanceof ClassDef) {
                classDef = Optional.of(object);
            } else if (object instanceof String) {
                classDef = this.getClassDefEntity(object);
            }
            if (!classDef.isPresent()) {
                classDef = this._properties.getClassDef(key, defaultClassDef);
            }
        }
        return classDef;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<ClassDefEntity> getClassDefEntity(@Nonnull String name) {
        return this._classDefsByName != null ? Optional.ofNullable(this._classDefsByName.get(name.toUpperCase(Locale.ROOT))) : Optional.empty();
    }

    @Nonnull
    @CheckReturnValue
    public final ClassDef[] getClassDefs(@Nonnull String key) {
        return this._properties.getClassDefs(key);
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<ClassLibEntity> getClassLibEntity(@Nonnull String name) {
        return Optional.ofNullable(this._classLibsByName.get(name.toUpperCase(Locale.ROOT)));
    }

    @Nonnull
    @CheckReturnValue
    public final synchronized ServiceClassLoader getClassLoader() {
        if (this._classLoader == null) {
            this.setClassLoader(Optional.empty());
        }
        return this._classLoader;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<String> getConfigDir() {
        return this.getStringValue(CONFIG_DIR_PROPERTY);
    }

    @Nonnull
    @CheckReturnValue
    public final File getDataDir() {
        if (this._dataDir == null) {
            this._dataDir = Config.dataDir(Optional.empty(), this.getProperties(), SERVICE_DATA_DIR_PROPERTY, DEFAULT_SERVICE_DATA_DIR);
            this.getThisLogger().debug(ServiceMessages.DATA_DIR, this._dataDir.getAbsolutePath());
        }
        return this._dataDir;
    }

    @CheckReturnValue
    public final double getDoubleValue(String key, double defaultValue) {
        return this._properties.getDouble(key, defaultValue);
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<ElapsedTime> getElapsedValue(@Nonnull String key, @Nonnull Optional<ElapsedTime> defaultValue, @Nonnull Optional<ElapsedTime> emptyValue) {
        return this._properties.getElapsed(key, defaultValue, emptyValue);
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<HashMap<String, Entity>> getEntities() {
        return this._state.getEntities();
    }

    @Nonnull
    @CheckReturnValue
    public final File getFile(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            URI uri;
            URL url = this.getURL();
            try {
                uri = url.toURI();
                uri = "file".equalsIgnoreCase(uri.getScheme()) ? new File(uri).getParentFile().toURI() : CWD_URI;
            }
            catch (URISyntaxException exception) {
                uri = CWD_URI;
            }
            file = new File(new File(uri), path);
        }
        return file;
    }

    @CheckReturnValue
    public final int getIntValue(@Nonnull String key, int defaultValue) {
        return this._properties.getInt(key, defaultValue);
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<char[]> getPasswordValue(@Nonnull String key) {
        return this._properties.getPassword(key);
    }

    @Nonnull
    @CheckReturnValue
    public final ConfigProperties getProperties() {
        return this._properties;
    }

    @Nonnull
    @CheckReturnValue
    public final KeyedGroups getPropertiesGroup(@Nonnull String key) {
        return this._properties.getGroup(Require.notNull(key));
    }

    @Nonnull
    @CheckReturnValue
    public final KeyedGroups[] getPropertiesGroups(@Nonnull String key) {
        return this._properties.getGroups(key);
    }

    @Nonnull
    @CheckReturnValue
    public final String getRootName() {
        return Require.notNull(this._rootName);
    }

    @Nonnull
    @CheckReturnValue
    public final Service getService() {
        return Require.notNull(this._service);
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<ServiceContext> getServiceContext(@Nonnull String key) {
        String serviceKey = key.toUpperCase(Locale.ROOT);
        ServiceContext serviceContext = this._serviceContexts.get(serviceKey);
        if (serviceContext == null) {
            serviceContext = this._servicesByAlias.get(serviceKey);
        }
        return Optional.ofNullable(serviceContext);
    }

    @Nonnull
    @CheckReturnValue
    public final Collection<ServiceContext> getServiceContexts() {
        return this._serviceContexts.values();
    }

    @Nonnull
    @CheckReturnValue
    public final String getServiceName() {
        return this._serviceName;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<String> getServiceName(String key) {
        Optional<ServiceContext> serviceContext = this.getServiceContext(key);
        return serviceContext.isPresent() ? Optional.of(serviceContext.get().getServiceName()) : Optional.empty();
    }

    @Nonnull
    @CheckReturnValue
    public final ConfigProperties getServiceProperties() {
        ConfigProperties overrider = this._properties.getOverrider().get();
        return overrider.getOverriden().get();
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<UUID> getServiceUUID() {
        return this._service != null ? this._service.getServiceUUID() : Optional.empty();
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<DateTime> getStamp() {
        return this._stamp;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<String> getStringValue(@Nonnull String key) {
        return this.getStringValue(key, Optional.empty());
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<String> getStringValue(@Nonnull String key, @Nonnull Optional<String> defaultValue) {
        return this._properties.getString(key, defaultValue);
    }

    @Nonnull
    @CheckReturnValue
    public final String[] getStringValues(@Nonnull String key) {
        return this._properties.getStrings(Require.notNull(key));
    }

    @Nonnull
    @CheckReturnValue
    public URL getURL() {
        return Require.notNull(this._url);
    }

    @CheckReturnValue
    public final boolean hasService() {
        return this._service != null;
    }

    @CheckReturnValue
    public boolean isIncluded(@Nonnull URL url) {
        return !this._state.include(url);
    }

    public final void keepEntities(@Nonnull Optional<HashMap<String, Entity>> entities) {
        this._state.setEntities(entities);
    }

    @CheckReturnValue
    public boolean registerClassLib(@Nonnull String classLibName) {
        Optional<ClassLibEntity> classLib = this.getClassLibEntity(classLibName);
        if (!classLib.isPresent()) {
            this.getThisLogger().warn(ServiceMessages.CLASS_LIB_UNKNOWN, classLibName);
            return false;
        }
        if (this._classLoader == null) {
            this.registerClassLoader();
        }
        try {
            this._classLoader.addFromClassLib(classLib.get());
        }
        catch (UndefinedEntityException exception) {
            this.getThisLogger().warn(BaseMessages.VERBATIM, exception.getMessage());
            return false;
        }
        return true;
    }

    public final void registerClassLoader() {
        this.getClassLoader().activate();
    }

    public final void restoreState(@Nonnull Object state) {
        this._state = new _State((_State)state);
    }

    @Nonnull
    public final Optional<HashMap<String, Entity>> returnEntities() {
        Optional<HashMap<String, Entity>> entities = this._state.getEntities();
        this._state.setEntities(Optional.empty());
        return entities;
    }

    @Nonnull
    @CheckReturnValue
    public final Object saveState() {
        return new _State(this._state);
    }

    public final synchronized void setClassLoader(@Nonnull Optional<ServiceClassLoader> classLoader) {
        this._classLoader = classLoader.orElse(ServiceClassLoader.getInstance());
        this._classLoader.useConfig(this);
    }

    public final void setConfigDir(@Nonnull String dir) {
        this._properties.setValue(CONFIG_DIR_PROPERTY, dir);
    }

    public final void setRootName(@Nonnull String rootName) {
        this._rootName = rootName;
    }

    public final void setService(@Nonnull Service service) {
        this._service = service;
    }

    public final void setServiceProperties(@Nonnull ConfigProperties properties) {
        ConfigProperties overrider = this._properties.getOverrider().get();
        overrider.setOverriden(properties);
    }

    public void setURL(@Nonnull URL url) {
        this._url = url;
    }

    public final void setUpService() {
        this.setServiceProperties(this.getServiceContext(this.getServiceName()).get());
    }

    @Nonnull
    @CheckReturnValue
    public final Params substitute(@Nonnull Params params) {
        Params clonedParams = params.copy();
        for (Map.Entry<String, List<Object>> entry : clonedParams.getValuesEntries()) {
            ListIterator<Object> iterator = entry.getValue().listIterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                if (!(value instanceof String)) continue;
                iterator.set(this.getProperties().substitute((String)value, false));
            }
        }
        clonedParams.freeze();
        return clonedParams;
    }

    @Nonnull
    @CheckReturnValue
    public final String substitute(@Nonnull String text, boolean deferred) {
        return this.getProperties().substitute(text, deferred);
    }

    public void tearDown() {
        ServiceClassLoader classLoader = this._classLoader;
        if (classLoader != null) {
            this._classLoader = null;
            classLoader.forgetConfig(this);
        }
        this._serviceContexts.clear();
        this._servicesByAlias.clear();
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this));
    }

    public final void updateStamp(@Nonnull Optional<DateTime> stamp) {
        if (!this._stamp.isPresent() || stamp.isPresent() && stamp.get().isAfter(this._stamp.get())) {
            this._stamp = stamp;
        }
    }

    @Nonnull
    @CheckReturnValue
    protected final Logger getThisLogger() {
        return this._logger;
    }

    private static void createFile(File directory, String filename, String content) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(directory, filename)), StandardCharsets.UTF_8);
        writer.write(content);
        ((Writer)writer).close();
    }

    private void _fetchResourceProperties() {
        String resourceName = System.getProperty(RVPF_PROPERTIES, RVPF_PROPERTIES);
        Optional<ConfigProperties> systemProperties = this._properties.getOverrider();
        boolean substitutionDeferred = systemProperties.isPresent() ? systemProperties.get().getBoolean(SUBSTITUTION_DEFERRED_PROPERTY) : false;
        boolean substitutionEnabled = systemProperties.isPresent() ? systemProperties.get().getBoolean(SUBSTITUTION_ENABLED_PROPERTY) : false;
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(resourceName);
            if (!resources.hasMoreElements()) {
                this.getThisLogger().info(ServiceMessages.NO_RESOURCES, resourceName);
            }
            Enumeration<URL> i = resources;
            while (i.hasMoreElements()) {
                URL url = i.nextElement();
                this.getThisLogger().debug(ServiceMessages.LOADING_PROPERTIES, url);
                DocumentPropertiesMap properties = DocumentPropertiesMap.fetch(DocumentStream.create(url), Optional.empty());
                this.updateStamp(properties.getStamp());
                for (Map.Entry entry : properties.entrySet()) {
                    String key = (String)entry.getKey();
                    if (systemProperties.get().containsValueKey(key)) continue;
                    String value = (String)entry.getValue();
                    if (substitutionEnabled && value != null) {
                        value = systemProperties.get().substitute(value, substitutionDeferred);
                    }
                    if (value != null) {
                        systemProperties.get().setValue(key, value);
                    } else {
                        systemProperties.get().removeValue(key);
                    }
                    if (!key.equals(SUBSTITUTION_ENABLED_PROPERTY)) continue;
                    substitutionEnabled = ValueConverter.convertToBoolean(systemProperties.get().getType(), key, Optional.ofNullable(value), false);
                }
            }
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static final class _State {
        private HashMap<String, Entity> _entities;
        private final Set<String> _included;

        _State() {
            this._included = new HashSet<String>();
        }

        _State(_State state) {
            this._entities = new HashMap<String, Entity>(state._entities);
            this._included = new HashSet<String>(state._included);
        }

        Optional<HashMap<String, Entity>> getEntities() {
            return Optional.ofNullable(this._entities);
        }

        boolean include(URL url) {
            return this._included.add(url.toExternalForm());
        }

        void setEntities(Optional<HashMap<String, Entity>> entities) {
            this._entities = entities.orElse(null);
        }
    }
}

