/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Message;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.util.container.KeyedValues;
import org.rvpf.service.ServiceContext;
import org.rvpf.service.ServiceMessages;

@NotThreadSafe
public class ConfigProperties
extends KeyedGroups {
    public static final ConfigProperties MISSING_CONFIG_PROPERTIES;
    public static final ConfigProperties[] NO_CONFIG_PROPERTIES;
    private static final long serialVersionUID = 1L;
    private transient PropertyChangeSupport _changeSupport;
    private transient ConfigProperties _overriden;
    private transient ConfigProperties _overrider;

    public ConfigProperties() {
        this(BaseMessages.VALUE_TYPE, Optional.empty());
    }

    public ConfigProperties(@Nonnull Messages.Entry type) {
        this(type, Optional.empty());
    }

    public ConfigProperties(@Nonnull Optional<String> name) {
        this(BaseMessages.VALUE_TYPE, name);
    }

    public ConfigProperties(@Nonnull Messages.Entry type, @Nonnull Optional<String> name) {
        super(type.toString(), name);
    }

    private ConfigProperties(ConfigProperties other) {
        super(other);
        if (other._overrider != null) {
            ConfigProperties configProperties = this._overrider = !(other._overrider instanceof ServiceContext) ? other._overrider.copy() : null;
        }
        if (other._overriden != null) {
            this._overriden = !(other._overriden instanceof ServiceContext) ? other._overriden.copy() : null;
        }
    }

    public void add(@Nonnull KeyedGroups otherInstance) {
        super.addAll(otherInstance);
    }

    public void add(@Nonnull Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.add((String)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void add(String key, Object value) {
        if (this._changeSupport != null && this._changeSupport.hasListeners(key)) {
            this.setValue(key, value);
        } else {
            super.add(key, value);
        }
    }

    public final void addPropertyChangeListener(@Nonnull String key, @Nonnull PropertyChangeListener listener) {
        if (this._changeSupport == null) {
            this._changeSupport = new PropertyChangeSupport(this);
        }
        this._changeSupport.addPropertyChangeListener(Require.notNull(key), Require.notNull(listener));
    }

    public void clearOverriden() {
        this._overriden = null;
    }

    @Override
    public final boolean containsGroupKey(String key) {
        if (this._overrider != null && this._overrider.containsGroupKey(key)) {
            return true;
        }
        if (super.containsGroupKey(key)) {
            return true;
        }
        return this._overriden != null && this._overriden.containsGroupKey(key);
    }

    @Override
    public final boolean containsValueKey(String key) {
        if (this._overrider != null && this._overrider.containsValueKey(key)) {
            return true;
        }
        if (super.containsValueKey(key)) {
            return true;
        }
        return this._overriden != null && this._overriden.containsValueKey(key);
    }

    @Override
    public ConfigProperties copy() {
        return new ConfigProperties(this);
    }

    @Override
    public final boolean equals(Object other) {
        if (super.equals(other)) {
            ArrayList<Map.Entry<String, List<Object>>> groups = new ArrayList<Map.Entry<String, List<Object>>>(this.getGroupsEntries());
            ArrayList<Map.Entry<String, List<Object>>> otherGroups = new ArrayList<Map.Entry<String, List<Object>>>(((ConfigProperties)other).getGroupsEntries());
            groups.sort(MAP_ENTRY_COMPARATOR);
            otherGroups.sort(MAP_ENTRY_COMPARATOR);
            return groups.equals(otherGroups);
        }
        return false;
    }

    @Override
    @Nonnull
    public ConfigProperties freeze() {
        if (this._overrider != null) {
            this._overrider.freeze();
        }
        super.freeze();
        if (this._overriden != null) {
            this._overriden.freeze();
        }
        return this;
    }

    @Override
    public final ConfigProperties getGroup(String key) {
        ConfigProperties group = this._overrider == null ? this.getMissingGroup() : this._overrider.getGroup(key);
        if (group.isMissing() && (group = (ConfigProperties)super.getGroup(key)).isMissing() && this._overriden != null) {
            group = this._overriden.getGroup(key);
        }
        return group;
    }

    @Override
    public final KeyedGroups[] getGroups(String key) {
        KeyedGroups[] groups = this._overrider == null ? this.getNoGroups() : this._overrider.getGroups(key);
        if (groups.length == 0 && (groups = super.getGroups(key)).length == 0 && this._overriden != null) {
            groups = this._overriden.getGroups(key);
        }
        return groups;
    }

    @Override
    public final List<Object> getObjects(String key) {
        List<Object> objects = this._overrider != null ? this._overrider.getObjects(key) : Collections.emptyList();
        if (objects.isEmpty() && (objects = super.getObjects(key)).isEmpty() && this._overriden != null) {
            objects = this._overriden.getObjects(key);
        }
        return objects;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<ConfigProperties> getOverriden() {
        return Optional.ofNullable(this._overriden);
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<ConfigProperties> getOverrider() {
        return Optional.ofNullable(this._overrider);
    }

    @Override
    public final int hashCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this._overrider != null && !this._overrider.isEmpty() || this._overriden != null && !this._overriden.isEmpty());
    }

    public final void removePropertyChangeListener(@Nonnull PropertyChangeListener listener) {
        PropertyChangeListener[] listeners;
        for (PropertyChangeListener changeListener : listeners = this._changeSupport.getPropertyChangeListeners()) {
            PropertyChangeListenerProxy listenerProxy = (PropertyChangeListenerProxy)changeListener;
            if (listenerProxy.getListener() != listener) continue;
            this._changeSupport.removePropertyChangeListener(listenerProxy);
        }
    }

    public final void restoreMonitoredValues(@Nonnull Object values) {
        if (this._changeSupport != null) {
            _MonitoredValues monitoredValues = (_MonitoredValues)values;
            for (String key : monitoredValues.getValuesKeys()) {
                this.setObjects(key, monitoredValues.getObjects(key));
            }
        }
    }

    @Nonnull
    @CheckReturnValue
    public final Object saveMonitoredValues() {
        _MonitoredValues monitoredValues = new _MonitoredValues(this.getType());
        if (this._changeSupport != null) {
            PropertyChangeListener[] listeners;
            for (PropertyChangeListener listener : listeners = this._changeSupport.getPropertyChangeListeners()) {
                PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
                String key = proxy.getPropertyName();
                monitoredValues.setObjects(key, super.getObjects(key));
            }
        }
        return monitoredValues.freeze();
    }

    public void setOverriden(@Nonnull ConfigProperties overriden) {
        this._overriden = Require.notNull(overriden);
    }

    public void setOverrider(@Nonnull ConfigProperties overrider) {
        this._overrider = Require.notNull(overrider);
    }

    @Override
    public void setValue(String key, Object value) {
        if (this._changeSupport != null) {
            Object previousValue = this.getObject(key).orElse(null);
            super.setValue(key, value);
            this._changeSupport.firePropertyChange(key, previousValue, value);
        } else {
            super.setValue(key, value);
        }
    }

    @Override
    protected final ConfigProperties getMissingGroup() {
        return MISSING_CONFIG_PROPERTIES;
    }

    protected final ConfigProperties[] getNoGroups() {
        return NO_CONFIG_PROPERTIES;
    }

    static {
        NO_CONFIG_PROPERTIES = new ConfigProperties[0];
        MISSING_CONFIG_PROPERTIES = new ConfigProperties(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isMissing() {
                return true;
            }
        };
        MISSING_CONFIG_PROPERTIES.freeze();
    }

    @NotThreadSafe
    private static final class _MonitoredValues
    extends KeyedValues {
        private static final long serialVersionUID = 1L;

        _MonitoredValues(@Nonnull String superType) {
            super(Message.format(ServiceMessages.MONITORED_TYPE, superType));
        }

        @Override
        public _MonitoredValues freeze() {
            super.freeze();
            return this;
        }

        @Override
        public void setObjects(String key, List<Object> objects) {
            super.setObjects(key, objects);
        }
    }
}

