/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.config.entity;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.rvpf.base.Attributes;
import org.rvpf.base.Entity;
import org.rvpf.base.UUID;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.Require;

public abstract class AbstractEntity
implements Entity {
    private Optional<String> _name = Optional.empty();
    private Optional<UUID> _uuid = Optional.empty();

    protected AbstractEntity() {
    }

    protected AbstractEntity(@Nonnull AbstractEntity other) {
        this.setName(other.getName());
        this.setUUID(other.getUUID());
    }

    protected AbstractEntity(@Nonnull Optional<String> name, @Nonnull Optional<UUID> uuid) {
        this._name = Require.notNull(name);
        this._uuid = Require.notNull(uuid);
    }

    @Override
    public int compareTo(Entity other) {
        int comparison = 0;
        if (this.getClass() != other.getClass()) {
            throw new ClassCastException();
        }
        if (this._name.isPresent()) {
            Optional<String> otherName = other.getName();
            comparison = otherName.isPresent() ? this._name.get().compareTo(otherName.get()) : -1;
        } else if (other.getName().isPresent()) {
            comparison = 1;
        }
        if (comparison == 0) {
            if (this._uuid.isPresent()) {
                Optional<UUID> otherUUID = other.getUUID();
                comparison = otherUUID.isPresent() ? this._uuid.get().compareTo(otherUUID.get()) : -1;
            } else if (other.getUUID().isPresent()) {
                comparison = 1;
            }
        }
        return comparison;
    }

    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AbstractEntity otherEntity = (AbstractEntity)other;
        return Objects.equals(this._uuid, otherEntity._uuid) && Objects.equals(this._name, otherEntity._name);
    }

    @Override
    public Optional<Attributes> getAttributes(String usage) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Optional<String> getName() {
        return this._name;
    }

    @Override
    public final Optional<String> getNameInUpperCase() {
        return Optional.ofNullable(this._name.isPresent() ? this._name.get().toUpperCase(Locale.ROOT) : null);
    }

    @Override
    public final Optional<UUID> getUUID() {
        return this._uuid;
    }

    public int hashCode() {
        return this._name.hashCode() ^ this._uuid.hashCode();
    }

    public final void setName(@Nonnull Optional<String> name) {
        this._name = name.isPresent() ? Optional.of(name.get().trim()) : Optional.empty();
    }

    public final void setUUID(@Nonnull Optional<UUID> uuid) {
        Require.failure(this._uuid.isPresent(), (Object)"UUID already set");
        this._uuid = uuid;
    }

    public String toString() {
        if (this._name.isPresent()) {
            return this._name.get();
        }
        if (this._uuid.isPresent()) {
            return this._uuid.get().toString();
        }
        return super.toString();
    }

    @Nonnull
    @CheckReturnValue
    protected final Logger getThisLogger() {
        return Logger.getInstance(this.getClass());
    }

    public static abstract class Builder {
        private String _name;
        private UUID _uuid;

        protected Builder() {
        }

        @Nonnull
        @CheckReturnValue
        public abstract AbstractEntity build();

        @Nonnull
        public Builder setName(Optional<String> name) {
            this._name = name.orElse(null);
            return this;
        }

        @Nonnull
        public Builder setName(String name) {
            this._name = name;
            return this;
        }

        @Nonnull
        public Builder setUUID(UUID uuid) {
            this._uuid = uuid;
            return this;
        }

        @Nonnull
        @OverridingMethodsMustInvokeSuper
        protected Builder copyFrom(@Nonnull AbstractEntity entity) {
            this._name = entity.getName().orElse(null);
            this._uuid = entity.getUUID().orElse(null);
            return this;
        }

        @Nonnull
        @CheckReturnValue
        protected Optional<String> getName() {
            return Optional.ofNullable(this._name);
        }

        @Nonnull
        @CheckReturnValue
        protected final Logger getThisLogger() {
            return Logger.getInstance(this.getClass());
        }

        protected Optional<UUID> getUUID() {
            return Optional.ofNullable(this._uuid);
        }
    }
}

