/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.config.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.ClassDef;
import org.rvpf.base.ClassDefImpl;
import org.rvpf.base.Entity;
import org.rvpf.base.UUID;
import org.rvpf.base.tool.Require;
import org.rvpf.config.TopologicalErrorException;
import org.rvpf.config.UndefinedEntityException;
import org.rvpf.config.entity.AbstractEntity;
import org.rvpf.config.entity.ClassLibEntity;
import org.rvpf.service.ServiceClassLoader;
import org.rvpf.service.ServiceMessages;

public class ClassDefEntity
extends AbstractEntity
implements ClassDef {
    public static final String ELEMENT_NAME = "ClassDef";
    public static final String ENTITY_PREFIX = "K";
    private boolean _busy;
    private Optional<ClassLibEntity> _classLib;
    private final ClassDefImpl _impl;
    private final List<ClassDefEntity> _implemented = new LinkedList<ClassDefEntity>();
    private Optional<Boolean> _initialized;
    private int _level = 1;

    ClassDefEntity(@Nonnull String name, @Nonnull ClassDefImpl impl, @Nonnull List<ClassDefEntity> implemented, @Nonnull Optional<ClassLibEntity> classLib, @Nonnull Optional<Boolean> initialized, int level) {
        super(Optional.of(name), Optional.empty());
        this._impl = Require.notNull(impl);
        this._implemented.addAll(implemented);
        this._classLib = classLib;
        this._initialized = initialized;
        this._level = level;
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    public final void addImplemented(@Nonnull ClassDefEntity classDef) {
        this._implemented.add(classDef);
    }

    public final void adjustLevel() throws TopologicalErrorException {
        this._adjustLevel(0);
    }

    @Override
    public final int compareTo(Entity other) {
        ClassDefEntity otherClassDef = (ClassDefEntity)other;
        int comparison = this.getLevel() - otherClassDef.getLevel();
        if (comparison == 0) {
            comparison = this.getClassName().compareTo(otherClassDef.getClassName());
        }
        return comparison;
    }

    @Override
    public ClassDefEntity copy() {
        return ClassDefEntity.newBuilder().copyFrom(this).build();
    }

    @Override
    public <T> T createInstance(Class<T> expectedClass) {
        if (!this._updateClassLoader()) {
            return null;
        }
        return this._impl.createInstance(expectedClass);
    }

    @Override
    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (super.equals(other)) {
            ClassDefEntity otherEntity = (ClassDefEntity)other;
            if (this.getClassName().equals(otherEntity.getClassName()) && Objects.equals(this._classLib, otherEntity._classLib)) {
                ArrayList<ClassDefEntity> implemented = new ArrayList<ClassDefEntity>(this.getImplemented());
                ArrayList<ClassDefEntity> otherImplemented = new ArrayList<ClassDefEntity>(otherEntity.getImplemented());
                implemented.sort(null);
                otherImplemented.sort(null);
                return implemented.equals(otherImplemented);
            }
        }
        return false;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<ClassLibEntity> getClassLib() {
        return this._classLib;
    }

    @Override
    public String getClassName() {
        return this._impl.getClassName();
    }

    @Override
    public final String getElementName() {
        return ELEMENT_NAME;
    }

    @Nonnull
    @CheckReturnValue
    public final List<ClassDefEntity> getImplemented() {
        return this._implemented;
    }

    @Override
    public Class<?> getInstanceClass() {
        if (!this._updateClassLoader()) {
            return null;
        }
        return this._impl.getInstanceClass();
    }

    @Override
    public final Class<?> getInstanceClass(Optional<ClassLoader> classLoader) {
        throw new UnsupportedOperationException();
    }

    @CheckReturnValue
    public final int getLevel() {
        return this._level;
    }

    @Override
    public String getMember() {
        return this._impl.getMember();
    }

    @Override
    public String getPackageName() {
        return this._impl.getPackageName();
    }

    @Override
    public final String getPrefix() {
        return ENTITY_PREFIX;
    }

    @Override
    public String getReferenceName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    @CheckReturnValue
    public final boolean is(@Nonnull Class<?> classObject) throws UndefinedEntityException {
        return this.is(classObject.getName());
    }

    @CheckReturnValue
    public final boolean is(@Nonnull String className) throws UndefinedEntityException {
        if (className.equals(this.getClassName())) {
            return true;
        }
        for (ClassDefEntity classDef : this._implemented) {
            if (!classDef.is(className)) continue;
            if (!classDef.isDefined()) {
                throw new UndefinedEntityException(classDef);
            }
            return true;
        }
        return false;
    }

    @CheckReturnValue
    public boolean isDefined() {
        return true;
    }

    @Override
    public boolean isLoaded() {
        if (!this._updateClassLoader()) {
            return false;
        }
        return this._impl.isLoaded();
    }

    @Override
    public final String toString() {
        return this.getClassName();
    }

    @Nonnull
    @CheckReturnValue
    ClassDefImpl getImpl() {
        return this._impl;
    }

    @Nonnull
    @CheckReturnValue
    Boolean getInitialized() {
        return this._initialized.get();
    }

    private void _adjustLevel(int level) throws TopologicalErrorException {
        if (this._busy) {
            throw new TopologicalErrorException(this);
        }
        if (level < this._level) {
            this._level = level;
            this._busy = true;
            for (ClassDefEntity classDef : this._implemented) {
                classDef._adjustLevel(this._level - 1);
            }
            this._busy = false;
        }
    }

    private synchronized boolean _updateClassLoader() {
        if (this._initialized.isPresent()) {
            return this._initialized.get();
        }
        try {
            if (!(Thread.currentThread().getContextClassLoader() instanceof ServiceClassLoader)) {
                ServiceClassLoader.getInstance().activate();
            }
            if (this._classLib.isPresent()) {
                ServiceClassLoader classLoader = (ServiceClassLoader)Thread.currentThread().getContextClassLoader();
                classLoader.addFromClassLib(this._classLib.get());
                this._classLib = null;
            }
            for (ClassDefEntity implemented : this._implemented) {
                if (!implemented.isDefined()) {
                    throw new UndefinedEntityException(implemented);
                }
                if (implemented._updateClassLoader()) continue;
                this._initialized = Optional.of(Boolean.FALSE);
            }
            if (!this._initialized.isPresent()) {
                this._initialized = Optional.of(Boolean.TRUE);
            }
        }
        catch (UndefinedEntityException exception) {
            this.getThisLogger().warn(BaseMessages.VERBATIM, exception.getMessage());
            this._initialized = Optional.of(Boolean.FALSE);
            return false;
        }
        if (this._initialized.get().booleanValue()) {
            Class<?> instanceClass = this._impl.getInstanceClass();
            if (instanceClass == null) {
                this._initialized = Optional.of(Boolean.FALSE);
            } else {
                for (ClassDefEntity implemented : this._implemented) {
                    Class<?> implementedClass = implemented.getInstanceClass();
                    if (implementedClass == null) {
                        this._initialized = Optional.of(Boolean.FALSE);
                        continue;
                    }
                    if (implementedClass.isAssignableFrom(instanceClass)) continue;
                    this.getThisLogger().warn(ServiceMessages.DOES_NOT_IMPLEMENT, instanceClass.getName(), implementedClass.getName());
                    this._initialized = Optional.of(Boolean.FALSE);
                }
            }
        }
        return this._initialized.get();
    }

    public static final class Undefined
    extends ClassDefEntity {
        private static final ClassDefImpl _IMPL = new ClassDefImpl("");

        public Undefined(@Nonnull String name) {
            super(name, _IMPL, Collections.emptyList(), Optional.empty(), Optional.empty(), 0);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        @Override
        public Undefined copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T createInstance(Class<T> expectedClass) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getClassName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Class<?> getInstanceClass() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMember() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPackageName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDefined() {
            return false;
        }

        @Override
        public boolean isLoaded() {
            return false;
        }

        public static final class Builder
        extends org.rvpf.config.entity.ClassDefEntity$Builder {
            private String _key;

            Builder() {
            }

            @Override
            public Undefined build() {
                return new Undefined(Require.notNull(this._key));
            }

            @Nonnull
            public Builder setKey(@Nonnull String key) {
                this._key = key;
                return this;
            }
        }
    }

    public static class Builder
    extends AbstractEntity.Builder {
        private Optional<ClassLibEntity> _classLib = Optional.empty();
        private ClassDefImpl _impl;
        private final List<ClassDefEntity> _implemented = new LinkedList<ClassDefEntity>();
        private Optional<Boolean> _initialized = Optional.empty();
        private int _level = 1;

        Builder() {
        }

        @Nonnull
        public Builder addImplemented(@Nonnull ClassDefEntity classDef) {
            this._implemented.add(classDef);
            return this;
        }

        @Override
        public ClassDefEntity build() {
            return new ClassDefEntity(this.getName().get(), this._impl, this._implemented, this._classLib, this._initialized, this._level);
        }

        @Nonnull
        public final Builder copyFrom(@Nonnull ClassDefEntity classDef) {
            super.copyFrom(classDef);
            this._impl = classDef.getImpl();
            this._implemented.clear();
            this._implemented.addAll(classDef.getImplemented());
            this._classLib = classDef.getClassLib();
            this._initialized = Optional.of(classDef.getInitialized());
            this._level = classDef.getLevel();
            return this;
        }

        @Nonnull
        public Builder setClassLib(@Nonnull ClassLibEntity classLib) {
            this._classLib = Optional.of(classLib);
            return this;
        }

        @Nonnull
        public Builder setImpl(@Nonnull ClassDefImpl impl) {
            this._impl = Require.notNull(impl);
            return this;
        }

        @Override
        public Builder setUUID(UUID uuid) {
            throw new UnsupportedOperationException();
        }
    }
}

