/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.config.entity;

import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Entity;
import org.rvpf.base.UUID;
import org.rvpf.base.tool.Require;
import org.rvpf.config.TopologicalErrorException;
import org.rvpf.config.entity.AbstractEntity;

public class ClassLibEntity
extends AbstractEntity {
    public static final String ELEMENT_NAME = "ClassLib";
    public static final String ENTITY_PREFIX = "L";
    private boolean _added;
    private boolean _busy;
    private final Optional<Boolean> _cached;
    private final List<ClassLibEntity> _classLibs;
    private int _level = 1;
    private final List<URI> _locations;

    ClassLibEntity(@Nonnull Optional<String> name, @Nonnull Optional<UUID> uuid, @Nonnull List<ClassLibEntity> classLibs, @Nonnull List<URI> locations, @Nonnull Optional<Boolean> cached, boolean added, int level) {
        super(name, uuid);
        this._classLibs = Require.notNull(classLibs);
        this._locations = Require.notNull(locations);
        this._cached = Require.notNull(cached);
        this._added = added;
        this._level = level;
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    public final void adjustLevel() throws TopologicalErrorException {
        this.adjustLevel(0);
    }

    @Override
    public final int compareTo(Entity other) {
        int comparison = this._level - ((ClassLibEntity)other)._level;
        if (comparison == 0) {
            Optional<String> name = this.getName();
            if (name.isPresent()) {
                Optional<String> otherName = other.getName();
                comparison = otherName.isPresent() ? name.get().compareTo(otherName.get()) : -1;
            } else if (other.getName().isPresent()) {
                comparison = 1;
            }
        }
        return comparison;
    }

    @Override
    public ClassLibEntity copy() {
        return ClassLibEntity.newBuilder().copyFrom(this).build();
    }

    @Override
    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (super.equals(other)) {
            ClassLibEntity otherEntity = (ClassLibEntity)other;
            if (this._cached.equals(otherEntity._cached)) {
                return this.getLocations().equals(otherEntity.getLocations());
            }
        }
        return false;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<Boolean> getCached() {
        return this._cached;
    }

    @Nonnull
    @CheckReturnValue
    public final List<ClassLibEntity> getClassLibs() {
        return this._classLibs;
    }

    @Override
    public final String getElementName() {
        return ELEMENT_NAME;
    }

    @CheckReturnValue
    public final int getLevel() {
        return this._level;
    }

    @Nonnull
    @CheckReturnValue
    public final List<URI> getLocations() {
        return this._locations;
    }

    @Override
    public final String getPrefix() {
        return ENTITY_PREFIX;
    }

    @Override
    public String getReferenceName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    @CheckReturnValue
    public final boolean isAdded() {
        return this._added;
    }

    @CheckReturnValue
    public final boolean isCached(boolean defaultValue) {
        return this._cached.isPresent() ? this._cached.get() : defaultValue;
    }

    @CheckReturnValue
    public boolean isDefined() {
        return true;
    }

    public final void setAdded(boolean added) {
        this._added = added;
    }

    private void adjustLevel(int level) throws TopologicalErrorException {
        if (this._busy) {
            throw new TopologicalErrorException(this);
        }
        if (level < this._level) {
            this._level = level;
            this._busy = true;
            for (ClassLibEntity classLib : this._classLibs) {
                classLib.adjustLevel(this._level - 1);
            }
            this._busy = false;
        }
    }

    public static final class Undefined
    extends ClassLibEntity {
        Undefined(@Nonnull String name) {
            super(Optional.of(name), Optional.empty(), Collections.emptyList(), Collections.emptyList(), Optional.empty(), false, 0);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        @Override
        public Undefined copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDefined() {
            return false;
        }

        public static final class Builder
        extends org.rvpf.config.entity.ClassLibEntity$Builder {
            private String _key;

            Builder() {
            }

            @Override
            public Undefined build() {
                return new Undefined(Require.notNull(this._key));
            }

            @Nonnull
            public Builder setKey(@Nonnull String key) {
                this._key = key;
                return this;
            }
        }
    }

    public static class Builder
    extends AbstractEntity.Builder {
        private boolean _added;
        private Optional<Boolean> _cached = Optional.empty();
        private final List<ClassLibEntity> _classLibs = new LinkedList<ClassLibEntity>();
        private int _level = 1;
        private final List<URI> _locations = new LinkedList<URI>();

        Builder() {
        }

        public final Builder addClassLib(@Nonnull ClassLibEntity classLib) {
            this._classLibs.add(classLib);
            return this;
        }

        public final Builder addLocation(@Nonnull URI location) {
            this._locations.add(location);
            return this;
        }

        @Override
        public ClassLibEntity build() {
            return new ClassLibEntity(this.getName(), this.getUUID(), this._classLibs, this._locations, this._cached, this._added, this._level);
        }

        public final Builder copyFrom(@Nonnull ClassLibEntity classLib) {
            super.copyFrom(classLib);
            this._classLibs.clear();
            this._classLibs.addAll(classLib.getClassLibs());
            this._locations.clear();
            this._locations.addAll(classLib.getLocations());
            this._cached = classLib.getCached();
            this._added = classLib.isAdded();
            this._level = classLib.getLevel();
            return this;
        }

        @CheckReturnValue
        public final boolean isCached(boolean defaultValue) {
            return this._cached.isPresent() ? this._cached.get() : defaultValue;
        }

        public final Builder setAdded(boolean added) {
            this._added = added;
            return this;
        }

        public final Builder setCached(@Nonnull Optional<Boolean> cached) {
            this._cached = cached;
            return this;
        }
    }
}

