/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.config.entity;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.config.entity.PropertyDefEntity;
import org.rvpf.config.entity.ValidatorDefEntity;

public final class PropertiesDefEntity
extends ValidatorDefEntity {
    public static final String ELEMENT_NAME = "PropertiesDef";
    public static final String ENTITY_PREFIX = "R";
    private final Map<String, PropertiesDefEntity> _propertiesDefs = new HashMap<String, PropertiesDefEntity>();
    private final Map<String, PropertyDefEntity> _propertyDefs = new HashMap<String, PropertyDefEntity>();
    private boolean _validated = true;

    public PropertiesDefEntity() {
    }

    private PropertiesDefEntity(@Nonnull PropertiesDefEntity other) {
        super(other);
        this._propertyDefs.putAll(other._propertyDefs);
        this._propertiesDefs.putAll(other._propertiesDefs);
        this._validated = other._validated;
    }

    public boolean addPropertiesDef(@Nonnull PropertiesDefEntity propertiesDef) {
        return this._propertiesDefs.put(propertiesDef.getName().get(), propertiesDef) == null;
    }

    public boolean addPropertyDef(@Nonnull PropertyDefEntity propertyDef) {
        return this._propertyDefs.put(propertyDef.getName().get(), propertyDef) == null;
    }

    @Override
    public PropertiesDefEntity copy() {
        return new PropertiesDefEntity(this);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return super.equals(other);
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    public String getPrefix() {
        return ENTITY_PREFIX;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<PropertiesDefEntity> getPropertiesDef(@Nonnull String name) {
        return Optional.ofNullable(this._propertiesDefs.get(name));
    }

    @Nonnull
    @CheckReturnValue
    public Collection<PropertiesDefEntity> getPropertiesDefs() {
        return this._propertiesDefs.values();
    }

    @Nonnull
    @CheckReturnValue
    public Optional<PropertyDefEntity> getPropertyDef(@Nonnull String name) {
        return Optional.ofNullable(this._propertyDefs.get(name));
    }

    @Nonnull
    @CheckReturnValue
    public Collection<PropertyDefEntity> getPropertyDefs() {
        return this._propertyDefs.values();
    }

    @Override
    public String getReferenceName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTarget() {
        return "properties";
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @CheckReturnValue
    public boolean isValidated() {
        return this._validated;
    }

    public void setValidated(boolean validated) {
        this._validated = validated;
    }
}

