/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.config.entity;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.UUID;
import org.rvpf.config.entity.AbstractEntity;

public abstract class ValidatorDefEntity
extends AbstractEntity {
    private boolean _hidden;
    private boolean _multiple;

    protected ValidatorDefEntity() {
    }

    protected ValidatorDefEntity(@Nonnull ValidatorDefEntity other) {
        super(other);
        this._hidden = other._hidden;
        this._multiple = other._multiple;
    }

    protected ValidatorDefEntity(@Nonnull Optional<String> name, @Nonnull Optional<UUID> uuid, boolean hidden, boolean multiple) {
        super(name, uuid);
        this._hidden = hidden;
        this._multiple = multiple;
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other)) {
            ValidatorDefEntity otherEntity = (ValidatorDefEntity)other;
            if (this.isHidden() != otherEntity.isHidden()) {
                return false;
            }
            return this.isMultiple() == otherEntity.isMultiple();
        }
        return false;
    }

    @Nonnull
    @CheckReturnValue
    public abstract String getTarget();

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @CheckReturnValue
    public final boolean isHidden() {
        return this._hidden;
    }

    @CheckReturnValue
    public final boolean isMultiple() {
        return this._multiple;
    }

    public final void setHidden(boolean hidden) {
        this._hidden = hidden;
    }

    public final void setMultiple(boolean multiple) {
        this._multiple = multiple;
    }

    public static abstract class Builder
    extends AbstractEntity.Builder {
        private boolean _hidden;
        private boolean _multiple;

        protected Builder() {
        }

        @CheckReturnValue
        public final boolean isHidden() {
            return this._hidden;
        }

        @CheckReturnValue
        public final boolean isMultiple() {
            return this._multiple;
        }

        @Nonnull
        public final Builder setHidden(boolean hidden) {
            this._hidden = hidden;
            return this;
        }

        @Nonnull
        public final Builder setMultiple(boolean multiple) {
            this._multiple = multiple;
            return this;
        }

        @Nonnull
        protected Builder copyFrom(@Nonnull ValidatorDefEntity validatorDefEntity) {
            super.copyFrom(validatorDefEntity);
            this._hidden = validatorDefEntity.isHidden();
            this._multiple = validatorDefEntity.isMultiple();
            return this;
        }
    }
}

