/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.ClassDef;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.config.Config;
import org.rvpf.service.Service;
import org.rvpf.service.ServiceActivator;
import org.rvpf.service.ServiceActivatorListener;
import org.rvpf.service.ServiceContext;
import org.rvpf.service.ServiceMessages;
import org.rvpf.service.app.ServiceAppImpl;

final class ContainerServiceAppImpl
extends ServiceAppImpl {
    public static final String CONFIG_PROPERTY = "config";
    public static final String NAME_PROPERTY = "name";
    public static final String OPTIONAL_PROPERTY = "optional";
    public static final String SERVICE_CLASS_PROPERTY = "service.class";
    public static final String SERVICE_PROPERTIES = "service";
    public static final String WAIT_PROPERTY = "wait";
    private final Set<ServiceActivator> _optionals = new HashSet<ServiceActivator>();
    private final Map<String, ServiceActivator> _serviceActivatorMap = new HashMap<String, ServiceActivator>();
    private final Set<ServiceActivator> _serviceActivators = new LinkedHashSet<ServiceActivator>();
    private boolean _stopping;

    ContainerServiceAppImpl() {
    }

    @Override
    public boolean setUp(Service service) {
        if (!super.setUp(service)) {
            return false;
        }
        Config config = service.getConfig();
        KeyedGroups[] services = config.getPropertiesGroups(SERVICE_PROPERTIES);
        if (services.length == 0) {
            this.getThisLogger().error(ServiceMessages.NO_SERVICES, new Object[0]);
            return false;
        }
        try {
            for (KeyedGroups serviceProperties : services) {
                if (this._prepareService(serviceProperties, config)) continue;
                return false;
            }
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return true;
    }

    @Override
    public void start() {
        ArrayList<ServiceActivator> serviceActivators = new ArrayList<ServiceActivator>(this._serviceActivators);
        Service containerService = this._getContainerService();
        for (ServiceActivator serviceActivator : serviceActivators) {
            this._startService(serviceActivator);
            if (!this._stopping && !containerService.isStopping()) continue;
            break;
        }
        if (this._stopping) {
            this.stop();
            containerService.getServiceActivator().stop();
        }
    }

    @Override
    public void stop() {
        LinkedList<ServiceActivator> serviceActivators = new LinkedList<ServiceActivator>(this._serviceActivators);
        while (!serviceActivators.isEmpty()) {
            ServiceActivator serviceActivator = serviceActivators.removeLast();
            if (!serviceActivator.isStarted()) continue;
            serviceActivator.stop();
            this._getContainerService().stopping();
        }
    }

    @Override
    public void tearDown() {
        LinkedList<ServiceActivator> serviceActivators = new LinkedList<ServiceActivator>(this._serviceActivators);
        while (!serviceActivators.isEmpty()) {
            serviceActivators.removeLast().destroy();
        }
        this._serviceActivators.clear();
        this._serviceActivatorMap.clear();
        super.tearDown();
    }

    Service _getContainerService() {
        return super.getService();
    }

    void _startService(ServiceActivator service) {
        boolean started;
        try {
            service.start();
            started = service.isStarted();
        }
        catch (Exception exception) {
            started = false;
        }
        if (!started) {
            this.getThisLogger().warn(ServiceMessages.SERVICE_START_FAILED, service);
            this._stopped(service);
        }
    }

    void _stopped(ServiceActivator service) {
        Service containerService = this._getContainerService();
        if (this._serviceActivators.remove(service)) {
            if (!this._optionals.remove(service) && !containerService.isStopping()) {
                this.getThisLogger().warn(ServiceMessages.SERVICE_NOT_OPTIONAL, service);
                if (containerService.isRunning()) {
                    containerService.getServiceActivator().stop();
                } else {
                    this._stopping = true;
                }
            } else if (this._serviceActivators.isEmpty() && !containerService.isStopping()) {
                this.getThisLogger().info(ServiceMessages.NO_SERVICES_RUNNING, new Object[0]);
                containerService.getServiceActivator().stop();
            }
        }
    }

    @Nonnull
    @CheckReturnValue
    Optional<ServiceActivator> getServiceActivator(@Nonnull String serviceKey) {
        return Optional.ofNullable(this._serviceActivatorMap.get(serviceKey.toUpperCase(Locale.ROOT)));
    }

    private boolean _prepareService(KeyedGroups serviceProperties, Config containerConfig) throws Exception {
        Optional<ClassDef> classDef = serviceProperties.getClassDef(SERVICE_CLASS_PROPERTY, Optional.empty());
        if (!classDef.isPresent()) {
            this.getThisLogger().error(ServiceMessages.MISSING_SERVICE_PROPERTY, SERVICE_CLASS_PROPERTY);
            return false;
        }
        ServiceActivator service = classDef.get().createInstance(ServiceActivator.class);
        if (service == null) {
            return false;
        }
        service.setObjectNameProperty(Optional.empty());
        Optional<String> name = serviceProperties.getString(NAME_PROPERTY);
        if (name.isPresent()) {
            service.setObjectName(service.makeObjectName(name));
            this.getThisLogger().debug(ServiceMessages.SERVICE_NAME, service.getObjectName());
        }
        service.create();
        Optional<String> configURL = serviceProperties.getString(CONFIG_PROPERTY);
        if (configURL.isPresent()) {
            service.setConfigURL(configURL.get());
        }
        boolean wait = serviceProperties.getBoolean(WAIT_PROPERTY);
        service.setWait(wait | this._getContainerService().isWait());
        service.setListener(new _Listener(service));
        this._serviceActivators.add(service);
        boolean optional = serviceProperties.getBoolean(OPTIONAL_PROPERTY);
        if (optional) {
            this._optionals.add(service);
        }
        String serviceName = service.getObjectName().toString();
        this._serviceActivatorMap.put(serviceName.toUpperCase(Locale.ROOT), service);
        Optional<ServiceContext> serviceContext = containerConfig.getServiceContext(serviceName);
        if (!serviceContext.isPresent()) {
            this.getThisLogger().warn(ServiceMessages.SERVICE_NOT_CONFIGURED, serviceName);
            return false;
        }
        for (String alias : serviceContext.get().getServiceAliases()) {
            this._serviceActivatorMap.put(alias.toUpperCase(Locale.ROOT), service);
        }
        this.getThisLogger().info(ServiceMessages.SERVICE_PREPARED, service);
        return true;
    }

    private final class _Listener
    implements ServiceActivatorListener {
        private boolean _restarting;
        private final ServiceActivator _service;

        _Listener(ServiceActivator service) {
            this._service = service;
        }

        @Override
        public void restart(Optional<ElapsedTime> delay) {
            this._restarting = true;
            this._service.stop();
            if (delay.isPresent()) {
                try {
                    Thread.sleep(delay.get().toMillis());
                }
                catch (InterruptedException exception) {
                    throw new RuntimeException(exception);
                }
            }
            this._restarting = false;
            ContainerServiceAppImpl.this._startService(this._service);
        }

        @Override
        public void starting(Optional<ElapsedTime> waitHint) {
            Service containerService = ContainerServiceAppImpl.this._getContainerService();
            if (!containerService.isStarted()) {
                containerService.starting(waitHint);
            }
        }

        @Override
        public void stopped() {
            if (!this._restarting) {
                ContainerServiceAppImpl.this._stopped(this._service);
            }
        }

        @Override
        public void stopping(Optional<ElapsedTime> waitHint) {
            Service containerService = ContainerServiceAppImpl.this._getContainerService();
            if (!containerService.isStopped()) {
                containerService.stopping(waitHint);
            }
        }

        @Override
        public void terminate() {
            this._service.stop();
            Logger.getInstance(this.getClass()).info(ServiceMessages.SERVICE_TERMINATED, this._service);
        }
    }
}

