/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.content;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.Content;
import org.rvpf.base.Point;
import org.rvpf.base.value.NormalizedValue;
import org.rvpf.base.value.PointValue;
import org.rvpf.content.AbstractContent;
import org.rvpf.content.NumberContent;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.entity.ProxyEntity;

public final class BigDecimalContent
extends NumberContent {
    public static final String MULTIPLIER_PARAM = "Multiplier";
    public static final String SCALE_PARAM = "Scale";
    private Optional<Integer> _defaultScale;
    private Map<Integer, _Instance> _instances;
    private Optional<BigDecimal> _multiplier;

    @Override
    public Serializable decode(PointValue pointValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Serializable denormalize(NormalizedValue normalizedValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Content getInstance(Point point) {
        Integer scale;
        if (point.getParams().containsValueKey(SCALE_PARAM)) {
            scale = point.getParams().getInt(SCALE_PARAM, 0);
        } else if (this._defaultScale.isPresent()) {
            scale = this._defaultScale.get();
        } else {
            this.getThisLogger().error(BaseMessages.MISSING_PARAMETER, SCALE_PARAM);
            return null;
        }
        _Instance instance = this._instances.get(scale);
        if (instance == null) {
            instance = new _Instance(scale);
            this._instances.put(scale, instance);
        }
        return instance;
    }

    @Override
    public Serializable normalize(PointValue pointValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setUp(Metadata metadata, ProxyEntity proxyEntity) {
        if (!super.setUp(metadata, proxyEntity)) {
            return false;
        }
        Optional<String> multiplier = this.getParams().getString(MULTIPLIER_PARAM);
        this._multiplier = multiplier.isPresent() ? Optional.of(new BigDecimal(multiplier.get())) : Optional.empty();
        boolean scalePresent = this.getParams().containsValueKey(SCALE_PARAM);
        this._defaultScale = scalePresent ? Optional.of(this.getParams().getInt(SCALE_PARAM, 0)) : Optional.empty();
        this._instances = new HashMap<Integer, _Instance>();
        return true;
    }

    Optional<BigDecimal> _getMultiplier() {
        return this._multiplier;
    }

    private final class _Instance
    extends AbstractContent {
        private final int _scale;

        _Instance(int scale) {
            this._scale = scale;
        }

        @Override
        public Serializable decode(PointValue pointValue) {
            return this._getBigDecimal(pointValue);
        }

        @Override
        public Serializable denormalize(NormalizedValue normalizedValue) {
            Optional<BigDecimal> multiplier = BigDecimalContent.this._getMultiplier();
            BigDecimal bigDecimalValue = this._getBigDecimal(normalizedValue);
            if (bigDecimalValue != null && multiplier.isPresent()) {
                bigDecimalValue = bigDecimalValue.divide(multiplier.get(), RoundingMode.HALF_EVEN);
            }
            return bigDecimalValue;
        }

        @Override
        public Serializable normalize(PointValue pointValue) {
            Optional<BigDecimal> multiplier = BigDecimalContent.this._getMultiplier();
            BigDecimal bigDecimalValue = this._getBigDecimal(pointValue);
            if (bigDecimalValue != null && multiplier.isPresent()) {
                bigDecimalValue = bigDecimalValue.multiply(multiplier.get());
            }
            return bigDecimalValue;
        }

        private BigDecimal _getBigDecimal(PointValue pointValue) {
            BigDecimal bigDecimal;
            Serializable value = pointValue.getValue();
            if (value instanceof BigDecimal) {
                bigDecimal = (BigDecimal)value;
            } else if (value instanceof Double) {
                bigDecimal = BigDecimal.valueOf(Math.round((Double)value));
            } else if (value instanceof Float) {
                bigDecimal = BigDecimal.valueOf(Math.round(((Float)value).floatValue()));
            } else if (value instanceof Number) {
                bigDecimal = BigDecimal.valueOf(((Number)value).longValue());
            } else if (value instanceof String) {
                try {
                    bigDecimal = new BigDecimal((String)((Object)value));
                }
                catch (NumberFormatException exception) {
                    bigDecimal = null;
                }
            } else {
                bigDecimal = value instanceof Boolean ? BigDecimal.valueOf((Boolean)value != false ? 1L : 0L) : null;
            }
            if (bigDecimal != null) {
                bigDecimal = bigDecimal.setScale(this._scale, RoundingMode.HALF_EVEN);
            } else if (value != null) {
                this.warnBadValue(pointValue);
            }
            return bigDecimal;
        }
    }
}

