/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.content;

import java.io.Serializable;
import java.math.BigInteger;
import org.rvpf.base.value.NormalizedValue;
import org.rvpf.base.value.PointValue;
import org.rvpf.content.NumberContent;

public class BigIntegerContent
extends NumberContent {
    @Override
    public Serializable decode(PointValue pointValue) {
        return this._getBigInteger(pointValue);
    }

    @Override
    public Serializable denormalize(NormalizedValue normalizedValue) {
        return this._getBigInteger(normalizedValue);
    }

    @Override
    public Serializable normalize(PointValue pointValue) {
        return this._getBigInteger(pointValue);
    }

    private BigInteger _getBigInteger(PointValue pointValue) {
        Serializable value = pointValue.getValue();
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Double) {
            return BigInteger.valueOf(Math.round((Double)value));
        }
        if (value instanceof Float) {
            return BigInteger.valueOf(Math.round(((Float)value).floatValue()));
        }
        if (value instanceof Number) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        if (value instanceof String) {
            try {
                return new BigInteger((String)((Object)value));
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (value instanceof Boolean) {
            return BigInteger.valueOf((Boolean)value != false ? 1L : 0L);
        }
        if (value != null) {
            this.warnBadValue(pointValue);
        }
        return null;
    }
}

