/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.content;

import java.io.Serializable;
import org.rvpf.base.value.BigRational;
import org.rvpf.base.value.NormalizedValue;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.Rational;
import org.rvpf.content.FloatingPointContent;

public class BigRationalContent
extends FloatingPointContent {
    @Override
    public Serializable decode(PointValue pointValue) {
        return this._getBigRational(pointValue);
    }

    @Override
    public Serializable denormalize(NormalizedValue normalizedValue) {
        return this._getBigRational(normalizedValue);
    }

    @Override
    public Serializable normalize(PointValue pointValue) {
        return this._getBigRational(pointValue);
    }

    private BigRational _getBigRational(PointValue pointValue) {
        Serializable value = pointValue.getValue();
        if (value instanceof BigRational) {
            return (BigRational)value;
        }
        if (value instanceof Rational) {
            return BigRational.valueOf((Rational)value);
        }
        if (value instanceof Double) {
            return BigRational.valueOf(Math.round((Double)value), 1L);
        }
        if (value instanceof Float) {
            return BigRational.valueOf(Math.round(((Float)value).floatValue()), 1L);
        }
        if (value instanceof Number) {
            return BigRational.valueOf(((Number)value).longValue(), 1L);
        }
        if (value instanceof String) {
            try {
                return BigRational.valueOf((String)((Object)value));
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (value instanceof Boolean) {
            return BigRational.valueOf((Boolean)value != false ? 1L : 0L, 1L);
        }
        if (value != null) {
            this.warnBadValue(pointValue);
        }
        return null;
    }
}

