/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.content;

import java.io.Serializable;
import org.rvpf.base.tool.ValueConverter;
import org.rvpf.base.value.NormalizedValue;
import org.rvpf.base.value.PointValue;
import org.rvpf.content.AbstractContent;

public class BooleanContent
extends AbstractContent {
    @Override
    public final Boolean decode(PointValue pointValue) {
        return this._getBoolean(pointValue);
    }

    @Override
    public final Boolean denormalize(NormalizedValue normalizedValue) {
        return this._getBoolean(normalizedValue);
    }

    @Override
    public final Boolean normalize(PointValue pointValue) {
        return this._getBoolean(pointValue);
    }

    private Boolean _getBoolean(PointValue pointValue) {
        Serializable value = pointValue.getValue();
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue() != 0L;
        }
        if (value instanceof String) {
            String string = (String)((Object)value);
            if (ValueConverter.isTrue(string)) {
                return Boolean.TRUE;
            }
            if (ValueConverter.isFalse(string)) {
                return Boolean.FALSE;
            }
        }
        if (value != null) {
            this.warnBadValue(pointValue);
        }
        return null;
    }
}

