/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.content;

import java.io.Serializable;
import org.rvpf.base.value.NormalizedValue;
import org.rvpf.base.value.PointValue;
import org.rvpf.content.NumberContent;

public final class ByteContent
extends NumberContent {
    @Override
    public Byte decode(PointValue pointValue) {
        return this._getByte(pointValue);
    }

    @Override
    public Byte denormalize(NormalizedValue normalizedValue) {
        return this._getByte(normalizedValue);
    }

    @Override
    public Byte normalize(PointValue pointValue) {
        return this._getByte(pointValue);
    }

    private Byte _getByte(PointValue pointValue) {
        Serializable value = pointValue.getValue();
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Double) {
            return (byte)Math.round((Double)value);
        }
        if (value instanceof Float) {
            return (byte)Math.round(((Float)value).doubleValue());
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            try {
                return Byte.decode((String)((Object)value));
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (value instanceof Boolean) {
            return (byte)((Boolean)value != false ? 1 : 0);
        }
        if (value != null) {
            this.warnBadValue(pointValue);
        }
        return null;
    }
}

