/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.content;

import java.io.Serializable;
import org.rvpf.base.value.Complex;
import org.rvpf.base.value.NormalizedValue;
import org.rvpf.base.value.PointValue;
import org.rvpf.content.AbstractContent;

public final class ComplexContent
extends AbstractContent {
    @Override
    public Serializable decode(PointValue pointValue) {
        return this._getComplex(pointValue);
    }

    @Override
    public Serializable denormalize(NormalizedValue normalizedValue) {
        return this._getComplex(normalizedValue);
    }

    @Override
    public Serializable normalize(PointValue pointValue) {
        return this._getComplex(pointValue);
    }

    private Complex _getComplex(PointValue pointValue) {
        Serializable value = pointValue.getValue();
        if (value instanceof Complex) {
            return (Complex)value;
        }
        if (value instanceof Number) {
            return Complex.cartesian((Double)value, 0.0);
        }
        if (value instanceof String) {
            try {
                return Complex.valueOf((String)((Object)value));
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (value instanceof Boolean) {
            return Complex.cartesian((Boolean)value != false ? 1.0 : 0.0, 0.0);
        }
        if (value != null) {
            this.warnBadValue(pointValue);
        }
        return null;
    }
}

