/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.content;

import java.io.Serializable;
import java.util.Map;
import org.rvpf.base.util.container.KeyedValues;
import org.rvpf.base.value.Dict;
import org.rvpf.base.value.NormalizedValue;
import org.rvpf.base.value.PointValue;
import org.rvpf.content.ContainerContent;

public class DictContent
extends ContainerContent {
    @Override
    public Serializable decode(PointValue pointValue) {
        Dict dict = this._getDict(pointValue);
        if (dict != null) {
            PointValue clone = pointValue.copy();
            for (Map.Entry<String, Serializable> entry : dict.entrySet()) {
                clone.setValue(entry.getValue());
                entry.setValue(this.getContent().decode(clone));
            }
        }
        return dict;
    }

    @Override
    public Serializable denormalize(NormalizedValue normalizedValue) {
        Dict dict = this._getDict(normalizedValue);
        if (dict != null) {
            NormalizedValue clone = normalizedValue.copy();
            for (Map.Entry<String, Serializable> entry : dict.entrySet()) {
                clone.setValue(entry.getValue());
                entry.setValue(this.getContent().denormalize(clone));
            }
        }
        return dict;
    }

    @Override
    public Serializable encode(PointValue pointValue) {
        Dict dict = this._getDict(pointValue);
        if (dict != null) {
            PointValue clone = pointValue.copy();
            for (Map.Entry<String, Serializable> entry : dict.entrySet()) {
                clone.setValue(entry.getValue());
                entry.setValue(this.getContent().encode(clone));
            }
        }
        return dict;
    }

    @Override
    public Serializable normalize(PointValue pointValue) {
        Dict dict = this._getDict(pointValue);
        if (dict != null) {
            PointValue clone = pointValue.copy();
            for (Map.Entry<String, Serializable> entry : dict.entrySet()) {
                clone.setValue(entry.getValue());
                entry.setValue(this.getContent().normalize(clone));
            }
        }
        return dict;
    }

    private Dict _getDict(PointValue pointValue) {
        Serializable value = pointValue.getValue();
        if (value instanceof Dict) {
            Dict dict = (Dict)value;
            return dict.isFrozen() ? dict.clone() : dict;
        }
        if (value instanceof Map) {
            Map map = (Map)((Object)value);
            Dict dict = new Dict(KeyedValues.hashCapacity(map.size()));
            try {
                for (Map.Entry entry : map.entrySet()) {
                    dict.put((String)entry.getKey(), (Serializable)entry.getValue());
                }
                return dict;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (value != null) {
            this.warnBadValue(pointValue);
        }
        return null;
    }
}

