/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.content;

import java.io.Serializable;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.value.NormalizedValue;
import org.rvpf.base.value.PointValue;
import org.rvpf.content.FloatingPointContent;

public class DoubleContent
extends FloatingPointContent {
    @Override
    public final Double decode(PointValue pointValue) {
        return this.getDouble(pointValue);
    }

    @Override
    public Double denormalize(NormalizedValue normalizedValue) {
        return this.getDouble(normalizedValue);
    }

    @Override
    public Double normalize(PointValue pointValue) {
        return this.getDouble(pointValue);
    }

    @Nullable
    @CheckReturnValue
    protected final Double getDouble(@Nonnull PointValue pointValue) {
        Serializable value = pointValue.getValue();
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.valueOf((String)((Object)value));
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        if (value != null) {
            this.warnBadValue(pointValue);
        }
        return null;
    }
}

