/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.content;

import java.io.Serializable;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.value.NormalizedValue;
import org.rvpf.base.value.PointValue;
import org.rvpf.content.FloatingPointContent;

public class FloatContent
extends FloatingPointContent {
    @Override
    public final Float decode(PointValue pointValue) {
        return this.getFloat(pointValue);
    }

    @Override
    public Float denormalize(NormalizedValue normalizedValue) {
        return this.getFloat(normalizedValue);
    }

    @Override
    public Float normalize(PointValue pointValue) {
        return this.getFloat(pointValue);
    }

    @Nullable
    @CheckReturnValue
    protected final Float getFloat(@Nonnull PointValue pointValue) {
        Serializable value = pointValue.getValue();
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            try {
                return Float.valueOf((String)((Object)value));
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (value instanceof Boolean) {
            return Float.valueOf((Boolean)value != false ? 1.0f : 0.0f);
        }
        if (value != null) {
            this.warnBadValue(pointValue);
        }
        return null;
    }
}

