/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.content;

import java.io.Serializable;
import org.rvpf.base.value.NormalizedValue;
import org.rvpf.base.value.PointValue;
import org.rvpf.content.NumberContent;

public final class IntegerContent
extends NumberContent {
    @Override
    public Integer decode(PointValue pointValue) {
        return this._getInteger(pointValue);
    }

    @Override
    public Integer denormalize(NormalizedValue normalizedValue) {
        return this._getInteger(normalizedValue);
    }

    @Override
    public Integer normalize(PointValue pointValue) {
        return this._getInteger(pointValue);
    }

    private Integer _getInteger(PointValue pointValue) {
        Serializable value = pointValue.getValue();
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Double) {
            return (int)Math.round((Double)value);
        }
        if (value instanceof Float) {
            return (int)Math.round(((Float)value).doubleValue());
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.decode((String)((Object)value));
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        if (value != null) {
            this.warnBadValue(pointValue);
        }
        return null;
    }
}

