/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.content;

import java.io.Serializable;
import org.rvpf.base.value.NormalizedValue;
import org.rvpf.base.value.PointValue;
import org.rvpf.content.NumberContent;

public final class LongContent
extends NumberContent {
    @Override
    public Long decode(PointValue pointValue) {
        return this._getLong(pointValue);
    }

    @Override
    public Long denormalize(NormalizedValue normalizedValue) {
        return this._getLong(normalizedValue);
    }

    @Override
    public Long normalize(PointValue pointValue) {
        return this._getLong(pointValue);
    }

    private Long _getLong(PointValue pointValue) {
        Serializable value = pointValue.getValue();
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Double) {
            return Math.round((Double)value);
        }
        if (value instanceof Float) {
            return Math.round(((Float)value).doubleValue());
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return Long.decode((String)((Object)value));
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        if (value != null) {
            this.warnBadValue(pointValue);
        }
        return null;
    }
}

