/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.content;

import java.io.Serializable;
import org.rvpf.base.value.BigRational;
import org.rvpf.base.value.NormalizedValue;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.Rational;
import org.rvpf.content.FloatingPointContent;

public final class RationalContent
extends FloatingPointContent {
    @Override
    public Serializable decode(PointValue pointValue) {
        return this._getRational(pointValue);
    }

    @Override
    public Serializable denormalize(NormalizedValue normalizedValue) {
        return this._getRational(normalizedValue);
    }

    @Override
    public Serializable normalize(PointValue pointValue) {
        return this._getRational(pointValue);
    }

    private Rational _getRational(PointValue pointValue) {
        Serializable value = pointValue.getValue();
        if (value instanceof Rational) {
            return (Rational)value;
        }
        if (value instanceof BigRational) {
            BigRational bigRational = (BigRational)value;
            return Rational.valueOf(bigRational.getNumerator().longValue(), bigRational.getDenominator().longValue());
        }
        if (value instanceof Double) {
            return Rational.valueOf(Math.round((Double)value), 1L);
        }
        if (value instanceof Float) {
            return Rational.valueOf(Math.round(((Float)value).floatValue()), 1L);
        }
        if (value instanceof Number) {
            return Rational.valueOf(((Number)value).longValue(), 1L);
        }
        if (value instanceof String) {
            try {
                return Rational.valueOf((String)((Object)value));
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (value instanceof Boolean) {
            return Rational.valueOf((Boolean)value != false ? 1L : 0L, 1L);
        }
        if (value != null) {
            this.warnBadValue(pointValue);
        }
        return null;
    }
}

