/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.content;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.Content;
import org.rvpf.base.Point;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.NormalizedValue;
import org.rvpf.base.value.PointValue;
import org.rvpf.content.DoubleContent;
import org.rvpf.content.FloatingPointContent;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.entity.ProxyEntity;
import org.rvpf.service.ServiceMessages;

public final class SIContent
extends FloatingPointContent {
    public static final String UNIT_PARAM = "Unit";
    private static final double[] _MULTIPLIERS = new double[]{1.0E25, 1.0E22, 1.0E19, 1.0E16, 1.0E13, 1.0E10, 1.0E7, 10000.0, 1000.0, 100.0, 1.0, 0.1, 0.01, 1.0E-5, 1.0E-8, 1.0E-11, 1.0E-14, 1.0E-17, 1.0E-20, 1.0E-23};
    private static final String[] _PREFIXES = new String[]{"Y", "Z", "E", "P", "T", "G", "M", "k", "h", "da", "d", "c", "m", "u", "n", "p", "f", "a", "z", "y"};
    private static final String[] _UNITS = new String[]{"m", "g", "s", "A", "K", "mol", "cd", "rad", "sr", "Hz", "N", "Pa", "J", "W", "C", "V", "F", "O", "S", "Wb", "T", "H", "lm", "lx", "Bq", "Gy", "Sv", "kat"};
    private Map<Double, _Instance> _instances;
    private Map<String, Double> _multipliers;
    private Set<String> _units;

    @Override
    public Serializable decode(PointValue pointValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double denormalize(NormalizedValue normalizedValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Content getInstance(Point point) {
        _Instance instance;
        Optional<String> unit = point.getParams().getString(UNIT_PARAM);
        if (!unit.isPresent()) {
            this.getThisLogger().error(BaseMessages.MISSING_PARAMETER, UNIT_PARAM);
            return null;
        }
        String base = unit.get();
        Double multiplier = 1.0;
        if (!this._units.contains(base)) {
            String prefix = base.substring(0, 1);
            base = base.substring(1);
            if ("d".equals(prefix) && base.startsWith("a")) {
                prefix = prefix + "a";
                base = base.substring(1);
            }
            if ((multiplier = this._multipliers.get(prefix)) == null || !this._units.contains(base)) {
                this.getThisLogger().error(ServiceMessages.UNRECOGNIZED_UNIT, unit.get());
                return null;
            }
        }
        if ("g".equals(base)) {
            multiplier = multiplier / 10000.0;
        }
        if ((instance = this._instances.get(multiplier)) == null) {
            instance = new _Instance(multiplier);
            this._instances.put(multiplier, instance);
        }
        return instance;
    }

    @Override
    public Serializable normalize(PointValue pointValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setUp(Metadata metadata, ProxyEntity proxyEntity) {
        if (!super.setUp(metadata, proxyEntity)) {
            return false;
        }
        this._units = new HashSet<String>(Arrays.asList(_UNITS));
        Require.equal(_MULTIPLIERS.length, _PREFIXES.length);
        this._multipliers = new HashMap<String, Double>();
        for (int i = 0; i < _PREFIXES.length; ++i) {
            this._multipliers.put(_PREFIXES[i], _MULTIPLIERS[i]);
        }
        this._multipliers.put("\u00b5", this._multipliers.get("u"));
        this._instances = new HashMap<Double, _Instance>();
        return true;
    }

    @Override
    public void tearDown() {
        this._instances = null;
        this._multipliers = null;
        this._units = null;
        super.tearDown();
    }

    private static final class _Instance
    extends DoubleContent {
        private final double _multiplier;

        _Instance(double multiplier) {
            this._multiplier = multiplier;
        }

        @Override
        public Double denormalize(NormalizedValue normalizedValue) {
            Double doubleValue = super.denormalize(normalizedValue);
            if (doubleValue != null) {
                doubleValue = doubleValue / this._multiplier;
            }
            return doubleValue;
        }

        @Override
        public Double normalize(PointValue pointValue) {
            Double doubleValue = super.normalize(pointValue);
            if (doubleValue != null) {
                doubleValue = doubleValue * this._multiplier;
            }
            return doubleValue;
        }
    }
}

