/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.content;

import java.io.Serializable;
import org.rvpf.base.value.NormalizedValue;
import org.rvpf.base.value.PointValue;
import org.rvpf.content.NumberContent;

public final class ShortContent
extends NumberContent {
    @Override
    public Short decode(PointValue pointValue) {
        return this._getShort(pointValue);
    }

    @Override
    public Short denormalize(NormalizedValue normalizedValue) {
        return this._getShort(normalizedValue);
    }

    @Override
    public Short normalize(PointValue pointValue) {
        return this._getShort(pointValue);
    }

    private Short _getShort(PointValue pointValue) {
        Serializable value = pointValue.getValue();
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Double) {
            return (short)Math.round((Double)value);
        }
        if (value instanceof Float) {
            return (short)Math.round(((Float)value).doubleValue());
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            try {
                return Short.decode((String)((Object)value));
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (value instanceof Boolean) {
            return (short)((Boolean)value != false ? 1 : 0);
        }
        if (value != null) {
            this.warnBadValue(pointValue);
        }
        return null;
    }
}

