/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.content;

import java.io.Serializable;
import java.util.Collection;
import java.util.ListIterator;
import org.rvpf.base.value.NormalizedValue;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.Tuple;
import org.rvpf.content.ContainerContent;

public class TupleContent
extends ContainerContent {
    @Override
    public Serializable decode(PointValue pointValue) {
        Tuple tuple = this._getTuple(pointValue);
        if (tuple != null) {
            PointValue clone = pointValue.copy();
            ListIterator<Serializable> iterator = tuple.listIterator();
            while (iterator.hasNext()) {
                clone.setValue(iterator.next());
                iterator.set(this.getContent().decode(clone));
            }
        }
        return tuple;
    }

    @Override
    public Serializable denormalize(NormalizedValue normalizedValue) {
        Tuple tuple = this._getTuple(normalizedValue);
        if (tuple != null) {
            NormalizedValue clone = normalizedValue.copy();
            ListIterator<Serializable> iterator = tuple.listIterator();
            while (iterator.hasNext()) {
                clone.setValue(iterator.next());
                iterator.set(this.getContent().denormalize(clone));
            }
        }
        return tuple;
    }

    @Override
    public Serializable encode(PointValue pointValue) {
        Tuple tuple = this._getTuple(pointValue);
        if (tuple != null) {
            PointValue clone = pointValue.copy();
            ListIterator<Serializable> iterator = tuple.listIterator();
            while (iterator.hasNext()) {
                clone.setValue(iterator.next());
                iterator.set(this.getContent().encode(clone));
            }
        }
        return tuple;
    }

    @Override
    public Serializable normalize(PointValue pointValue) {
        Tuple tuple = this._getTuple(pointValue);
        if (tuple != null) {
            PointValue clone = pointValue.copy();
            ListIterator<Serializable> iterator = tuple.listIterator();
            while (iterator.hasNext()) {
                clone.setValue(iterator.next());
                iterator.set(this.getContent().normalize(clone));
            }
        }
        return tuple;
    }

    private Tuple _getTuple(PointValue pointValue) {
        Serializable value = pointValue.getValue();
        if (value instanceof Tuple) {
            Tuple tuple = (Tuple)value;
            return tuple.isFrozen() ? tuple.clone() : tuple;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)((Object)value);
            Tuple tuple = new Tuple(collection.size());
            try {
                for (Object object : collection) {
                    tuple.add((Serializable)object);
                }
                return tuple;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (value != null) {
            this.warnBadValue(pointValue);
        }
        return null;
    }
}

