/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.content;

import javax.annotation.CheckReturnValue;
import org.rvpf.base.value.NormalizedValue;
import org.rvpf.base.value.PointValue;
import org.rvpf.content.DoubleContent;
import org.rvpf.metadata.Metadata;
import org.rvpf.metadata.entity.ProxyEntity;

public class UnitValueContent
extends DoubleContent {
    public static final String MULTIPLIER_PARAM = "Multiplier";
    private double _multiplier;

    @Override
    public Double denormalize(NormalizedValue normalizedValue) {
        Double doubleValue = this.getDouble(normalizedValue);
        if (doubleValue != null) {
            doubleValue = doubleValue / this._multiplier;
        }
        return doubleValue;
    }

    @Override
    public Double normalize(PointValue pointValue) {
        Double doubleValue = this.getDouble(pointValue);
        if (doubleValue != null) {
            doubleValue = doubleValue * this._multiplier;
        }
        return doubleValue;
    }

    @Override
    public boolean setUp(Metadata metadata, ProxyEntity proxyEntity) {
        super.setUp(metadata, proxyEntity);
        this._multiplier = this.getParams().getDouble(MULTIPLIER_PARAM, 1.0);
        return true;
    }

    @CheckReturnValue
    protected final double getMultiplier() {
        return this._multiplier;
    }
}

