/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.util.Optional;
import org.rvpf.base.exception.ValidationException;
import org.rvpf.document.loader.DocumentElement;
import org.rvpf.document.loader.MetadataElementLoader;
import org.rvpf.metadata.entity.AttributeDefEntity;
import org.rvpf.metadata.entity.AttributesDefEntity;

final class AttributesDefLoader
extends MetadataElementLoader {
    AttributesDefLoader() {
    }

    @Override
    protected void process() throws ValidationException {
        AttributesDefEntity.Builder attributesDefBuilder = AttributesDefEntity.newBuilder();
        DocumentElement attributesDefElement = this.getElement();
        Optional<String> extendsAttribute = attributesDefElement.getAttributeValue("extends", Optional.empty());
        AttributesDefEntity extended = extendsAttribute.isPresent() ? (AttributesDefEntity)this.getEntity(extendsAttribute.get(), "A", true).orElse(null) : null;
        attributesDefBuilder.setUsage(attributesDefElement.getAttributeValue("usage"));
        if (extended != null) {
            for (AttributeDefEntity attributeDefEntity : extended.getAttributeDefs()) {
                attributesDefBuilder.addAttributeDef(attributeDefEntity);
            }
        }
        attributesDefBuilder.setHidden(attributesDefElement.getAttributeValue("hidden", attributesDefBuilder.isHidden()));
        attributesDefBuilder.setMultiple(attributesDefElement.getAttributeValue("multiple", attributesDefBuilder.isMultiple()));
        AttributeDefEntity.Builder attributeDefBuilder = AttributeDefEntity.newBuilder();
        for (DocumentElement attributeDefElement : attributesDefElement.getChildren("AttributeDef")) {
            if (!attributeDefElement.isEnabled()) continue;
            attributeDefBuilder.setName(attributeDefElement.getAttributeValue("name"));
            attributeDefBuilder.setHidden(attributeDefElement.getAttributeValue("hidden", false)).setMultiple(attributeDefElement.getAttributeValue("multiple", false));
            attributesDefBuilder.addAttributeDef(attributeDefBuilder.build());
        }
        AttributesDefEntity attributesDefEntity = attributesDefBuilder.build();
        this.putEntity(attributesDefEntity.getUsage(), attributesDefEntity);
    }
}

