/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.util.Optional;
import org.rvpf.base.ClassDefImpl;
import org.rvpf.base.exception.ValidationException;
import org.rvpf.config.entity.ClassDefEntity;
import org.rvpf.config.entity.ClassLibEntity;
import org.rvpf.document.loader.ConfigElementLoader;
import org.rvpf.document.loader.DocumentElement;

final class ClassDefLoader
extends ConfigElementLoader {
    ClassDefLoader() {
    }

    @Override
    protected void process() throws ValidationException {
        ClassLibEntity classLib;
        DocumentElement classDefElement = this.getElement();
        ClassDefEntity.Builder classDefBuilder = ClassDefEntity.newBuilder();
        Optional<String> name = classDefElement.getNameAttribute();
        String packageName = classDefElement.getAttributeValue("package", Optional.of("java.lang")).orElse(null);
        String member = classDefElement.getAttributeValue("member", name.isPresent() ? name : Optional.of("Object")).orElse(null);
        classDefBuilder.setName(name.get());
        classDefBuilder.setImpl(new ClassDefImpl(packageName, member));
        Optional<String> referenceAttribute = classDefElement.getAttributeValue("classLib", Optional.empty());
        ClassLibEntity classLibEntity = classLib = referenceAttribute.isPresent() ? this.getClassLibEntity(referenceAttribute.get()) : null;
        if (classLib != null) {
            classDefBuilder.setClassLib(classLib);
        }
        for (DocumentElement implementsElement : classDefElement.getChildren("implements")) {
            if (!implementsElement.isEnabled()) continue;
            classDefBuilder.addImplemented(this.getClassDefEntity(implementsElement.getAttributeValue("classDef")));
        }
        ClassDefEntity classDef = classDefBuilder.build();
        this.getConfig().addClassDefEntity(classDef);
        this.putEntity(classDef, classDefElement.getAttributeValue("supersede", false));
    }
}

