/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.exception.ValidationException;
import org.rvpf.config.UndefinedEntityException;
import org.rvpf.config.entity.ClassLibEntity;
import org.rvpf.document.loader.ConfigElementLoader;
import org.rvpf.document.loader.DocumentElement;
import org.rvpf.service.ServiceMessages;

final class ClassLibLoader
extends ConfigElementLoader {
    ClassLibLoader() {
    }

    @Override
    protected void process() throws ValidationException {
        DocumentElement classLibElement = this.getElement();
        ClassLibEntity.Builder classLibBuilder = ClassLibEntity.newBuilder();
        classLibBuilder.setUUID(classLibElement.getUUID().orElse(null)).setName((String)classLibElement.getNameAttribute().orElse(null));
        this._addLocation(classLibElement.getAttributeValue("location", Optional.of("")).get(), classLibBuilder);
        for (DocumentElement locationElement : classLibElement.getChildren("location")) {
            if (!locationElement.isEnabled()) continue;
            this._addLocation(locationElement.getAttributeValue("location", Optional.of("")).get(), classLibBuilder);
            this._addLocation(locationElement.getText(), classLibBuilder);
        }
        if (classLibElement.getAttributeValue("cached", Optional.empty()).isPresent()) {
            boolean cached = classLibElement.getAttributeValue("cached", false);
            classLibBuilder.setCached(Optional.of(cached));
            if (classLibBuilder.isCached(false) && !classLibElement.getUUID().isPresent()) {
                this.getLogger().warn(ServiceMessages.CLASS_LIB_ATTRIBUTES, "cached", "uuid");
                classLibBuilder.setCached(Optional.empty());
            }
        }
        for (DocumentElement referenceElement : classLibElement.getChildren("classLib")) {
            if (!referenceElement.isEnabled()) continue;
            classLibBuilder.addClassLib(this.getClassLibEntity(referenceElement.getAttributeValue("classLib")));
        }
        ClassLibEntity classLib = classLibBuilder.build();
        if (!(classLib.getUUID().isPresent() || classLib.getName().isPresent() || classLibElement.getId().isPresent())) {
            try {
                this.getConfig().getClassLoader().addFromClassLib(classLib);
            }
            catch (UndefinedEntityException exception) {
                throw new ValidationException(BaseMessages.VERBATIM, exception.getMessage());
            }
        } else {
            this.getConfig().addClassLibEntity(classLib);
            this.putEntity(classLib);
        }
    }

    private void _addLocation(String location, ClassLibEntity.Builder classLibBuilder) {
        location = location.trim();
        location = location.replace("\\\\", "/");
        location = location.replace("\\", "/");
        location = location.replace(":////", ":///");
        if ((location = location.replace("file:///..", "..")).length() > 0) {
            URI uri;
            try {
                uri = new URI(location);
            }
            catch (URISyntaxException exception) {
                this.getLogger().warn(ServiceMessages.BAD_LOCATION, location);
                return;
            }
            classLibBuilder.addLocation(uri);
        }
    }
}

