/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.DateTime;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.Require;
import org.rvpf.base.tool.ValueConverter;
import org.rvpf.config.Config;
import org.rvpf.config.ConfigProperties;
import org.rvpf.config.UndefinedEntityException;
import org.rvpf.document.loader.ClassDefLoader;
import org.rvpf.document.loader.ClassLibLoader;
import org.rvpf.document.loader.DocumentLoader;
import org.rvpf.document.loader.PropertiesDefLoader;
import org.rvpf.document.loader.PropertiesLoader;
import org.rvpf.document.loader.PropertyDefLoader;
import org.rvpf.document.loader.PropertyLoader;
import org.rvpf.document.loader.ServiceLoader;
import org.rvpf.service.ServiceClassLoader;
import org.rvpf.service.ServiceContext;
import org.rvpf.service.ServiceMessages;

public class ConfigDocumentLoader
extends DocumentLoader
implements PropertyChangeListener {
    public static final String CONFIG_PROPERTY = "config";
    public static final String CONFIG_ROOT = "config";
    public static final String DEFAULT_CONFIG = "rvpf-config.xml";
    public static final String[] DOCTYPE_STRINGS = new String[]{"-//Serge Brisson//DTD RVPF//EN", "http://rvpf.org/dtd/rvpf.dtd"};
    public static final String VALIDATION_DISABLED_PROPERTY = "validation.disabled";
    public static final String VALIDATION_ENABLED_PROPERTY = "validation.enabled";
    private static final String[][] _PREFIX_NAMES = new String[][]{{"K", "ClassDef"}, {"L", "ClassLib"}, {"R", "PropertiesDef"}, {"Y", "PropertyDef"}};
    private final Config _config;
    private boolean _validationEnabled;

    ConfigDocumentLoader(@Nonnull Config config, @Nonnull String root) {
        this._config = config;
        this._config.setRootName(root);
        this.addPrefixNames(_PREFIX_NAMES);
        this.handle("ClassDef", new ClassDefLoader());
        this.handle("ClassLib", new ClassLibLoader());
        this.handle("properties", new PropertiesLoader());
        this.handle("PropertiesDef", new PropertiesDefLoader());
        this.handle("property", new PropertyLoader());
        this.handle("PropertyDef", new PropertyDefLoader());
        this.handle("service", new ServiceLoader());
        this.setSubstitutionEnabled(this._config.getBooleanValue("substitution.enabled"));
        this.setSubstitutionDeferred(this._config.getBooleanValue("substitution.deferred"));
        this._setValidationEnabled(!this._config.getBooleanValue(VALIDATION_DISABLED_PROPERTY, !this._config.getBooleanValue(VALIDATION_ENABLED_PROPERTY, true)));
        this.setEntities(this._config.returnEntities());
    }

    private ConfigDocumentLoader(Config config) {
        this(config, "config");
    }

    @Nullable
    @CheckReturnValue
    public static Config loadConfig(@Nonnull String serviceName, @Nonnull Optional<String> from, @Nonnull Optional<ServiceClassLoader> classLoader) {
        Config config = new Config(serviceName);
        ConfigDocumentLoader documentLoader = new ConfigDocumentLoader(config);
        if (classLoader.isPresent()) {
            config.setClassLoader(classLoader);
        }
        if (!from.isPresent()) {
            from = config.getStringValue("config", Optional.of(DEFAULT_CONFIG));
        }
        if (!documentLoader.loadFrom(from.get(), Optional.empty())) {
            return null;
        }
        if (!serviceName.isEmpty()) {
            Optional<ServiceContext> serviceContext = config.getServiceContext(serviceName);
            if (serviceContext.isPresent()) {
                try {
                    config.getClassLoader().addFromClassLibs(serviceContext.get().getClassLibs());
                }
                catch (UndefinedEntityException exception) {
                    Logger.getInstance(ConfigDocumentLoader.class).error(BaseMessages.VERBATIM, exception.getMessage());
                    return null;
                }
            } else {
                Logger.getInstance(ConfigDocumentLoader.class).warn(ServiceMessages.SERVICE_NOT_CONFIGURED, serviceName);
                return null;
            }
            config.setUpService();
        }
        return config;
    }

    @Override
    public final void propertyChange(PropertyChangeEvent event) {
        String key = event.getPropertyName();
        Object value = event.getNewValue();
        if (value != null && !(value instanceof String)) {
            this.getThisLogger().warn(ServiceMessages.UNEXPECTED_VALUE_TYPE, key);
        } else if ("substitution.enabled".equals(key)) {
            this.setSubstitutionEnabled(ValueConverter.convertToBoolean(ServiceMessages.DYNAMIC_TYPE.toString(), "substitution.enabled", Optional.ofNullable((String)value), false));
        } else if ("substitution.deferred".equals(key)) {
            this.setSubstitutionDeferred(ValueConverter.convertToBoolean(ServiceMessages.DYNAMIC_TYPE.toString(), "substitution.deferred", Optional.ofNullable((String)value), false));
        } else if (VALIDATION_DISABLED_PROPERTY.equals(key)) {
            this._setValidationEnabled(!ValueConverter.convertToBoolean(ServiceMessages.DYNAMIC_TYPE.toString(), VALIDATION_DISABLED_PROPERTY, Optional.ofNullable((String)value), false));
        } else if (VALIDATION_ENABLED_PROPERTY.equals(key)) {
            this._setValidationEnabled(ValueConverter.convertToBoolean(ServiceMessages.DYNAMIC_TYPE.toString(), VALIDATION_ENABLED_PROPERTY, Optional.ofNullable((String)value), false));
        } else {
            Require.failure("Unexpected property change event: " + key);
        }
    }

    @Override
    protected DocumentLoader.RootHandler getRootHandler() {
        return new ConfigHandler();
    }

    @Override
    protected final String getRootName() {
        return this._config.getRootName();
    }

    @Override
    protected URL getURL() {
        return this._config.getURL();
    }

    @Override
    protected boolean loadFrom(String from, Optional<Reader> reader) {
        this.setSubstitutionEnabled(this._config.getBooleanValue("substitution.enabled"));
        this.setSubstitutionDeferred(this._config.getBooleanValue("substitution.deferred"));
        this._setValidationEnabled(!this._config.getBooleanValue(VALIDATION_DISABLED_PROPERTY, !this._config.getBooleanValue(VALIDATION_ENABLED_PROPERTY, true)));
        ConfigProperties configProperties = this._config.getProperties();
        configProperties.addPropertyChangeListener("substitution.enabled", this);
        configProperties.addPropertyChangeListener("substitution.deferred", this);
        configProperties.addPropertyChangeListener(VALIDATION_DISABLED_PROPERTY, this);
        configProperties.addPropertyChangeListener(VALIDATION_ENABLED_PROPERTY, this);
        boolean success = super.loadFrom(from, reader);
        configProperties.removePropertyChangeListener(this);
        configProperties.freeze();
        if (success) {
            if (this._config.getStamp().isPresent()) {
                this.getThisLogger().debug(ServiceMessages.DOCUMENT_TIME, this._config.getStamp().orElse(null));
            }
            this._config.keepEntities(this.getEntities());
        }
        return success && !this.getThisLogger().hasLogged(Logger.LogLevel.ERROR);
    }

    @Override
    protected boolean read(String xml) {
        if (!super.read(xml)) {
            return false;
        }
        this._config.keepEntities(this.getEntities());
        return true;
    }

    @Override
    protected final void setURL(URL url) {
        this._config.setURL(url);
        if ("file".equalsIgnoreCase(url.getProtocol()) && !this._config.getConfigDir().isPresent()) {
            String configDir;
            try {
                configDir = new File(new URI(url.toString())).getParent();
            }
            catch (URISyntaxException exception) {
                throw new RuntimeException(exception);
            }
            this.getThisLogger().debug(ServiceMessages.CONFIG_DIRECTORY, configDir);
            this._config.setConfigDir(configDir.replace('\\', '/'));
        }
    }

    @Override
    final Config getConfig() {
        return this._config;
    }

    boolean isValidationEnabled() {
        return this._validationEnabled;
    }

    private void _setValidationEnabled(boolean validationEnabled) {
        if (this._validationEnabled != validationEnabled) {
            this._validationEnabled = validationEnabled;
            this.getThisLogger().debug(ServiceMessages.VALIDATION_ENABLED, ValueConverter.toInteger(this._validationEnabled));
        }
    }

    class ConfigHandler
    extends DocumentLoader.RootHandler {
        ConfigHandler() {
            super(ConfigDocumentLoader.this);
        }

        @Override
        protected void onRootEnd() {
            super.onRootEnd();
            if (this.isEnabled()) {
                Optional<String> stampAttribute = this.getAttribute("stamp");
                Optional<DateTime> stamp = stampAttribute.isPresent() ? Optional.of(DateTime.now().valueOf(stampAttribute.get())) : Optional.empty();
                ConfigDocumentLoader.this.getConfig().updateStamp(stamp);
            }
        }
    }
}

