/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.Entity;
import org.rvpf.base.exception.ValidationException;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.util.container.KeyedValues;
import org.rvpf.config.entity.ClassDefEntity;
import org.rvpf.config.entity.ClassLibEntity;
import org.rvpf.config.entity.ValidatorDefEntity;
import org.rvpf.document.loader.DocumentElement;
import org.rvpf.document.loader.DocumentElementLoader;
import org.rvpf.service.ServiceMessages;

public abstract class ConfigElementLoader
extends DocumentElementLoader {
    public static final String ALIAS_ELEMENT = "alias";
    public static final String ALLOW_ATTRIBUTE = "allow";
    public static final String CACHED_ATTRIBUTE = "cached";
    public static final String CLASS_DEF_ENTITY = "ClassDef";
    public static final String CLASS_DEF_REFERENCE = "classDef";
    public static final String CLASS_LIB_ENTITY = "ClassLib";
    public static final String CLASS_LIB_REFERENCE = "classLib";
    public static final String DECRYPT_ATTRIBUTE = "decrypt";
    public static final String DECRYPT_KEY_ELEMENT = "decryptKey";
    public static final String DEF_ATTRIBUTE = "def";
    public static final String DENY_ATTRIBUTE = "deny";
    public static final String ENV_ATTRIBUTE = "env";
    public static final String EQ_ATTRIBUTE = "eq";
    public static final String EXTENDS_ATTRIBUTE = "extends";
    public static final String FROM_ATTRIBUTE = "from";
    public static final String HIDDEN_ATTRIBUTE = "hidden";
    public static final String IMPLEMENTS_ELEMENT = "implements";
    public static final String LOCATION_ATTRIBUTE = "location";
    public static final String LOCATION_ELEMENT = "location";
    public static final String MEMBER_ATTRIBUTE = "member";
    public static final String MULTIPLE_ATTRIBUTE = "multiple";
    public static final String OPTIONAL_ATTRIBUTE = "optional";
    public static final String OVERRIDES_ATTRIBUTE = "overrides";
    public static final String PACKAGE_ATTRIBUTE = "package";
    public static final String PROPERTIES_DEF_ENTITY = "PropertiesDef";
    public static final String PROPERTIES_ELEMENT = "properties";
    public static final String PROPERTY_ATTRIBUTE = "property";
    public static final String PROPERTY_DEF_ENTITY = "PropertyDef";
    public static final String PROPERTY_ELEMENT = "property";
    public static final String REQUIRED_ATTRIBUTE = "required";
    public static final String ROLE_ATTRIBUTE = "role";
    public static final String SECURITY_ATTRIBUTE = "security";
    public static final String SERVICE_ELEMENT = "service";
    public static final String STAMP_ATTRIBUTE = "stamp";
    public static final String SUPERSEDE_ATTRIBUTE = "supersede";
    public static final String SYSTEM_ATTRIBUTE = "system";
    public static final String VALIDATED_ATTRIBUTE = "validated";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String VALUE_ELEMENT = "value";
    public static final String VERIFY_ATTRIBUTE = "verify";
    public static final String VERIFY_KEY_ELEMENT = "verifyKey";
    private static final String[] _EMPTY_STRING_ARRAY = new String[0];

    @Nonnull
    @CheckReturnValue
    final ClassDefEntity getClassDefEntity(@Nonnull String key) throws ValidationException {
        return (ClassDefEntity)this.getEntity(key, "K");
    }

    @Nonnull
    @CheckReturnValue
    final ClassLibEntity getClassLibEntity(@Nonnull String key) throws ValidationException {
        Optional<? extends Entity> classLibEntity = this.getEntity(key, "L", true);
        if (!classLibEntity.isPresent()) {
            this.getLogger().trace(ServiceMessages.ENTITY_UNKNOWN, CLASS_LIB_ENTITY, key);
        }
        return classLibEntity.isPresent() ? (ClassLibEntity)classLibEntity.get() : ClassLibEntity.Undefined.newBuilder().setKey(key).build();
    }

    final void putValues(@Nonnull String name, @Nonnull DocumentElement element, @Nonnull KeyedGroups context, @Nonnull Optional<? extends ValidatorDefEntity> validator, @Nonnull KeyedValues target) throws ValidationException {
        Object value;
        boolean overrides = element.getAttributeValue(OVERRIDES_ATTRIBUTE, false);
        boolean hidden = element.getAttributeValue(HIDDEN_ATTRIBUTE, false);
        Optional<String> required = element.getAttributeValue(REQUIRED_ATTRIBUTE, Optional.empty());
        Optional<String> property = element.getAttributeValue("property", Optional.empty());
        Optional<String> env = element.getAttributeValue(ENV_ATTRIBUTE, Optional.empty());
        Optional<String> eq = element.getAttributeValue(EQ_ATTRIBUTE, Optional.empty());
        Optional<String> classDef = element.getAttributeValue(CLASS_DEF_REFERENCE, Optional.empty());
        Object[] values = null;
        if (validator.isPresent() && validator.get().isHidden() || hidden) {
            target.setValuesHidden(name);
        }
        if (overrides) {
            target.removeValue(name);
        }
        if (required.isPresent()) {
            if (property.isPresent()) {
                throw new ValidationException(ServiceMessages.CONFLICTING_ATTRIBUTES, "property", REQUIRED_ATTRIBUTE);
            }
            if (env.isPresent()) {
                throw new ValidationException(ServiceMessages.CONFLICTING_ATTRIBUTES, ENV_ATTRIBUTE, REQUIRED_ATTRIBUTE);
            }
            if (eq.isPresent()) {
                throw new ValidationException(ServiceMessages.CONFLICTING_ATTRIBUTES, EQ_ATTRIBUTE, REQUIRED_ATTRIBUTE);
            }
            if (classDef.isPresent()) {
                throw new ValidationException(ServiceMessages.CONFLICTING_ATTRIBUTES, CLASS_DEF_REFERENCE, REQUIRED_ATTRIBUTE);
            }
            if (element.getAttributeValue("value", Optional.empty()).isPresent() || element.getText().trim().length() > 0 || !element.getChildren("value").isEmpty()) {
                throw new ValidationException(ServiceMessages.CONFLICTING_ATTRIBUTES, "value", REQUIRED_ATTRIBUTE);
            }
            values = context.getValues(required.get());
            if (values.length == 0) {
                throw new ValidationException(BaseMessages.MISSING_PROPERTY, required.get());
            }
        }
        if (property.isPresent() && (values = context.getValues(property.get())).length == 0) {
            values = null;
        }
        if (values == null && env.isPresent() && (value = System.getenv(env.get())) != null) {
            values = new String[]{value};
        }
        if (eq.isPresent()) {
            if (values != null) {
                if (values.length != 1 || !(values[0] instanceof String)) {
                    throw new ValidationException(ServiceMessages.PROPERTY_EQ, name);
                }
                if (((String)values[0]).equalsIgnoreCase(element.getAttributeValue("value", Optional.of("")).orElse(null)) != element.getAttributeValue(EQ_ATTRIBUTE, true)) {
                    values = _EMPTY_STRING_ARRAY;
                }
            } else {
                values = _EMPTY_STRING_ARRAY;
            }
        }
        if (values != null) {
            for (Object value2 : values) {
                target.add(name, value2);
            }
        } else if (classDef.isPresent()) {
            if (element.getAttributeValue("value", Optional.empty()).isPresent()) {
                throw new ValidationException(ServiceMessages.CLASS_DEF_VALUE, new Object[0]);
            }
            target.add(name, this.getClassDefEntity(classDef.get()));
        } else {
            value = element.getAttributeValue("value", Optional.empty()).orElse(null);
            if (value != null) {
                target.add(name, value);
            }
            if (((String)(value = element.getText().trim())).length() > 0) {
                target.add(name, value);
            }
            for (DocumentElement valueElement : element.getChildren("value")) {
                if (!valueElement.isEnabled()) continue;
                classDef = valueElement.getAttributeValue(CLASS_DEF_REFERENCE, Optional.empty());
                if (classDef.isPresent()) {
                    target.add(name, this.getClassDefEntity(classDef.get()));
                }
                if (((String)(value = (String)valueElement.getAttributeValue("value", Optional.of("")).orElse(null))).length() > 0) {
                    target.add(name, value);
                }
                if (((String)(value = valueElement.getText().trim())).length() <= 0) continue;
                target.add(name, value);
            }
            if (target.containsValueKey(name)) {
                if (validator.isPresent() && !validator.get().isMultiple() && target.isMultiple(name)) {
                    throw new ValidationException(ServiceMessages.MULTIPLE_VALUES, validator.get().getTarget(), name);
                }
            } else if (!property.isPresent() && !env.isPresent()) {
                target.add(name, "");
            }
        }
    }
}

