/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.util.Optional;
import org.rvpf.base.exception.ValidationException;
import org.rvpf.document.loader.DocumentElement;
import org.rvpf.document.loader.MetadataElementLoader;
import org.rvpf.metadata.entity.ContentEntity;

final class ContentLoader
extends MetadataElementLoader {
    ContentLoader() {
    }

    @Override
    protected void process() throws ValidationException {
        if (!this.getMetadataFilter().areContentsNeeded()) {
            return;
        }
        ContentEntity.Builder contentBuilder = ContentEntity.newBuilder();
        this.setUpEntityBuilder(contentBuilder);
        DocumentElement contentElement = this.getElement();
        contentBuilder.setClassDef(Optional.of(this.getClassDefEntity(contentElement.getAttributeValue("classDef")))).setParams(this.getParams(contentElement, "Content")).setAttributes(this.getAttributes(contentElement));
        ContentEntity content = contentBuilder.build();
        this.addGroupMember(content);
        this.getMetadata().addContentEntity(Optional.of(content));
        this.anchorEntity(content);
        this.putEntity(content);
    }

    @Override
    String getEntityPrefix() {
        return "N";
    }
}

