/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.UUID;
import org.rvpf.base.exception.ValidationException;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.ValueConverter;
import org.rvpf.base.xml.XMLElement;
import org.rvpf.document.loader.DocumentLoader;
import org.rvpf.service.ServiceMessages;

public final class DocumentElement
extends XMLElement {
    public static final String ID_ATTRIBUTE = "id";
    public static final String IF_ATTRIBUTE = "if";
    public static final String IF_FALSE_ATTRIBUTE = "ifFalse";
    public static final String IF_TRUE_ATTRIBUTE = "ifTrue";
    public static final Pattern ILLEGAL_PATTERN = Pattern.compile("\\x00-\\x20\\x7f");
    public static final String LANG_ATTRIBUTE = "lang";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String SELF_REFERENCE = ".";
    public static final String UNLESS_ATTRIBUTE = "unless";
    public static final String USAGE_ATTRIBUTE = "usage";
    public static final String UUID_ATTRIBUTE = "uuid";
    private final DocumentLoader _document;

    DocumentElement(@Nonnull String name, @Nonnull DocumentLoader document) {
        super(name);
        this._document = document;
    }

    @Override
    public XMLElement copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public Optional<String> getAttributeValue(String name, Optional<String> defaultValue) {
        Optional<String> attributeValue = super.getAttributeValue(name, defaultValue);
        return attributeValue.isPresent() ? Optional.of(this._document.substitute(attributeValue.get())) : Optional.empty();
    }

    public List<DocumentElement> getChildren() {
        return super.getChildren();
    }

    public List<DocumentElement> getChildren(String name) {
        return super.getChildren(name);
    }

    @Override
    public XMLElement.Factory getFactory() {
        return this._document;
    }

    @Override
    public String getText() {
        return this._document.substitute(super.getText());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Nonnull
    @CheckReturnValue
    String getAttributeValue(@Nonnull String name) throws ValidationException {
        Optional<String> attributeValue = this.getAttributeValue(name, Optional.empty());
        if (!attributeValue.isPresent()) {
            throw new ValidationException(ServiceMessages.MISSING_ATTRIBUTE_IN, name, this.getName());
        }
        return attributeValue.get();
    }

    @CheckReturnValue
    boolean getAttributeValue(@Nonnull String name, boolean defaultValue) {
        Optional<String> value = this.getAttributeValue(name, Optional.empty());
        return ValueConverter.convertToBoolean(ServiceMessages.ATTRIBUTE_TYPE.toString(), name, value, defaultValue);
    }

    @Nonnull
    @CheckReturnValue
    Logger getDocumentLogger() {
        return this._document.getThisLogger();
    }

    @Nonnull
    @CheckReturnValue
    Optional<String> getId() {
        return this.getAttributeValue(ID_ATTRIBUTE, Optional.empty());
    }

    @Nonnull
    @CheckReturnValue
    Optional<String> getNameAttribute() {
        Optional<String> name = this.getAttributeValue(NAME_ATTRIBUTE, Optional.empty());
        if (name.isPresent()) {
            if (ILLEGAL_PATTERN.matcher(name.get()).find()) {
                this.getDocumentLogger().warn(ServiceMessages.NAME_CHARACTERS, name);
                name = Optional.empty();
            } else if (DocumentLoader.ID_PATTERN.matcher(name.get()).matches()) {
                this.getDocumentLogger().warn(ServiceMessages.NAME_LIKE_ID, name);
                name = Optional.empty();
            } else if (UUID.isUUID(name.get())) {
                this.getDocumentLogger().warn(ServiceMessages.NAME_LIKE_UUID, name.get());
            }
            if (!name.isPresent()) {
                this.removeAttribute(NAME_ATTRIBUTE);
            }
        }
        return name;
    }

    @Nonnull
    @CheckReturnValue
    Optional<UUID> getUUID() {
        String uuidString = this.getAttributeValue(UUID_ATTRIBUTE, Optional.empty()).orElse(null);
        if (uuidString == null) {
            return Optional.empty();
        }
        if (UUID.isUUID(uuidString)) {
            return UUID.fromString(uuidString);
        }
        try {
            return Optional.of(UUID.fromName(uuidString));
        }
        catch (IllegalArgumentException exception) {
            this.getDocumentLogger().warn(ServiceMessages.INVALID_UUID_ATTRIBUTE, uuidString);
            this.removeAttribute(UUID_ATTRIBUTE);
            return Optional.empty();
        }
    }

    @CheckReturnValue
    boolean isEnabled() {
        boolean enabled = true;
        Optional<String> condition = this.getAttributeValue(IF_ATTRIBUTE, Optional.empty());
        if (condition.isPresent() && !this._document.getConfig().getStringValue(condition.get()).isPresent()) {
            enabled = false;
        }
        if ((condition = this.getAttributeValue(UNLESS_ATTRIBUTE, Optional.empty())).isPresent() && this._document.getConfig().getStringValue(condition.get()).isPresent()) {
            enabled = false;
        }
        if ((condition = this.getAttributeValue(IF_TRUE_ATTRIBUTE, Optional.empty())).isPresent() && !this._document.getConfig().getBooleanValue(condition.get())) {
            enabled = false;
        }
        if ((condition = this.getAttributeValue(IF_FALSE_ATTRIBUTE, Optional.empty())).isPresent() && this._document.getConfig().getBooleanValue(condition.get())) {
            enabled = false;
        }
        return enabled;
    }
}

