/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.net.URL;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Entity;
import org.rvpf.base.exception.ValidationException;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.Require;
import org.rvpf.config.Config;
import org.rvpf.document.loader.DocumentElement;
import org.rvpf.document.loader.DocumentLoader;
import org.rvpf.service.ServiceMessages;

abstract class DocumentElementLoader {
    private DocumentLoader _documentLoader;
    private DocumentElement _element;

    DocumentElementLoader() {
    }

    @Nonnull
    @CheckReturnValue
    protected final Config getConfig() {
        return this.getDocumentLoader().getConfig();
    }

    @Nonnull
    @CheckReturnValue
    protected final URL getContextURL() {
        return this.getDocumentLoader().getContextURL();
    }

    @Nonnull
    @CheckReturnValue
    protected final DocumentLoader getDocumentLoader() {
        return Require.notNull(this._documentLoader);
    }

    @Nonnull
    @CheckReturnValue
    protected final DocumentElement getElement() {
        return Require.notNull(this._element);
    }

    @Nonnull
    @CheckReturnValue
    protected final Entity getEntity(@Nonnull String key, @Nonnull String prefix) throws ValidationException {
        return this.getEntity(key, prefix, false).get();
    }

    @Nonnull
    @CheckReturnValue
    protected final Optional<? extends Entity> getEntity(@Nonnull String key, @Nonnull String prefix, boolean optional) throws ValidationException {
        Optional<? extends Entity> entity = this.getDocumentLoader().getEntity(key, prefix);
        if (!entity.isPresent()) {
            if (!optional) {
                throw new ValidationException(ServiceMessages.ENTITY_UNKNOWN, this.getDocumentLoader().getPrefixName(prefix), key);
            }
            return Optional.empty();
        }
        return entity;
    }

    @Nonnull
    @CheckReturnValue
    protected Optional<String> getLang() {
        return this.getDocumentLoader().getLang();
    }

    @Nonnull
    @CheckReturnValue
    protected final Logger getLogger() {
        return this.getDocumentLoader().getThisLogger();
    }

    protected abstract void process() throws ValidationException;

    protected final void putEntity(@Nonnull Entity entity) {
        this.putEntity(entity, false);
    }

    protected final void putEntity(@Nonnull Entity entity, boolean supersede) {
        Optional<String> uuidAttribute;
        Optional<String> nameAttribute;
        DocumentElement element = this.getElement();
        Optional<String> elemendId = element.getId();
        if (elemendId.isPresent()) {
            this.getDocumentLoader().putEntity(elemendId.get(), entity, false);
        }
        if ((nameAttribute = element.getAttributeValue("name", Optional.empty())).isPresent()) {
            this.getDocumentLoader().putEntity(nameAttribute.get(), entity, supersede);
        }
        if ((uuidAttribute = element.getAttributeValue("uuid", Optional.empty())).isPresent()) {
            this.getDocumentLoader().putEntity(uuidAttribute.get(), entity, false);
        }
    }

    protected final void putEntity(@Nonnull String key, @Nonnull Entity entity) {
        this.getDocumentLoader().putEntity(key, entity, false);
    }

    protected final void removeEntity(@Nonnull String key, @Nonnull String prefix) {
        this.getDocumentLoader().removeEntity(key, prefix);
    }

    protected void updateTexts() {
    }

    final void process(@Nonnull DocumentElement element) throws ValidationException {
        this._setElement(element);
        if (element.isEnabled()) {
            this.process();
        }
    }

    final void setDocument(@Nonnull DocumentLoader documentLoader) {
        this._documentLoader = documentLoader;
    }

    final void updateTexts(@Nonnull DocumentElement element) {
        this._setElement(element);
        if (element.isEnabled()) {
            this.updateTexts();
        }
    }

    private void _setElement(@Nonnull DocumentElement element) {
        this._element = element;
    }
}

