/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.DateTime;
import org.rvpf.base.Entity;
import org.rvpf.base.UUID;
import org.rvpf.base.exception.ValidationException;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.security.Crypt;
import org.rvpf.base.security.SecurityContext;
import org.rvpf.base.tool.Require;
import org.rvpf.base.tool.ValueConverter;
import org.rvpf.base.util.ResourceURLHandler;
import org.rvpf.base.util.URLHandlerFactory;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.xml.XMLDocument;
import org.rvpf.base.xml.XMLElement;
import org.rvpf.config.Config;
import org.rvpf.config.ConfigProperties;
import org.rvpf.document.loader.DocumentElement;
import org.rvpf.document.loader.DocumentElementLoader;
import org.rvpf.document.loader.DocumentPIHandler;
import org.rvpf.document.loader.DocumentReader;
import org.rvpf.document.loader.DocumentStream;
import org.rvpf.service.ServiceMessages;

@NotThreadSafe
public abstract class DocumentLoader
implements XMLElement.Factory {
    public static final Pattern ID_PATTERN = Pattern.compile("_[0-9A-Z]+", 2);
    public static final char ID_PREFIX = '_';
    private XMLDocument _document;
    private Optional<HashMap<String, Entity>> _entities = Optional.empty();
    private final List<Handler> _handlers = new LinkedList<Handler>();
    private Optional<String> _lang = Optional.empty();
    private final Logger _logger = Logger.getInstance(this.getClass());
    private final Map<String, String> _prefixNames = new HashMap<String, String>();
    private boolean _substitutionDeferred;
    private boolean _substitutionEnabled;
    private final LinkedList<URL> _urls = new LinkedList();
    private boolean _validating;

    DocumentLoader() {
    }

    @Override
    public XMLElement newXMLElement(String name) {
        return new DocumentElement(name, this);
    }

    public void setValidating(boolean validating) {
        this._validating = validating;
    }

    protected final void addPrefixNames(@Nonnull String[][] prefixNames) {
        for (String[] prefixName : prefixNames) {
            this._prefixNames.put(prefixName[0], prefixName[1]);
        }
    }

    @Nonnull
    @CheckReturnValue
    protected final Optional<? extends Entity> getEntity(@Nonnull String key, @Nonnull String prefix) {
        Entity entity;
        if (this._entities.isPresent()) {
            entity = this._entities.get().get(DocumentLoader._entityKey(key, prefix));
            if (entity != null && !prefix.equals(entity.getPrefix())) {
                entity = null;
            }
        } else {
            entity = null;
        }
        return Optional.ofNullable(entity);
    }

    @Nonnull
    @CheckReturnValue
    protected final String getPrefixName(@Nonnull String prefix) {
        return Require.notNull(this._prefixNames.get(prefix));
    }

    @Nonnull
    @CheckReturnValue
    protected RootHandler getRootHandler() {
        return new RootHandler();
    }

    @Nonnull
    @CheckReturnValue
    protected abstract String getRootName();

    @Nonnull
    @CheckReturnValue
    protected final Logger getThisLogger() {
        return this._logger;
    }

    @Nonnull
    @CheckReturnValue
    protected abstract URL getURL();

    protected final void handle(@Nonnull String name, @Nonnull DocumentElementLoader loader) {
        String path = "/" + this.getRootName() + "/" + name;
        this._getHandlers().add(new Handler(Optional.of(path), Optional.of(loader)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    protected boolean loadFrom(@Nonnull String from, @Nonnull Optional<Reader> reader) {
        DocumentReader documentReader;
        String rootName = this.getRootName();
        URL fromURL = this.getConfig().createURL(from, Optional.empty());
        if (fromURL == null) {
            return false;
        }
        try {
            documentReader = DocumentReader.create(fromURL, reader, Optional.empty());
        }
        catch (FileNotFoundException exception) {
            this.getThisLogger().error(ServiceMessages.DOCUMENT_LOAD_FAILED, this.getRootName(), fromURL, exception.getMessage());
            return false;
        }
        if (!this._entities.isPresent()) {
            this._entities = Optional.of(new HashMap());
        }
        this.setURL(documentReader.getFromURL());
        this.getThisLogger().debug(ServiceMessages.LOADING_FROM, this.getRootName(), this.getURL());
        try {
            this._read(documentReader);
        }
        finally {
            try {
                documentReader.close();
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
        XMLElement rootElement = this._document.getRootElement();
        if (rootElement != null && !rootName.equals(rootElement.getName())) {
            this.getThisLogger().warn(ServiceMessages.UNEXPECTED_ROOT, rootName, rootElement.getName());
        }
        return !this.getThisLogger().hasLogged(Logger.LogLevel.ERROR);
    }

    @CheckReturnValue
    protected boolean read(@Nonnull String xml) {
        StringReader reader = new StringReader(xml);
        this._document = new XMLDocument();
        this._document.setElementFactory(this);
        this._document.setPIHandler(Optional.of(new DocumentPIHandler(this)));
        this._document.setValidating(this._validating);
        this._registerHandlers();
        try {
            this._document.parse(reader);
        }
        catch (XMLDocument.ParseException exception) {
            throw new RuntimeException(exception.getCause());
        }
        return !this.getThisLogger().hasLogged(Logger.LogLevel.ERROR);
    }

    protected final void setEntities(@Nonnull Optional<HashMap<String, Entity>> entities) {
        this._entities = entities;
    }

    protected final void setSubstitutionDeferred(boolean substitutionDeferred) {
        if (this._substitutionDeferred != substitutionDeferred) {
            this._substitutionDeferred = substitutionDeferred;
            this.getThisLogger().debug(ServiceMessages.SUBSTITUTION_DEFERRED, ValueConverter.toInteger(this._substitutionDeferred));
        }
    }

    protected final void setSubstitutionEnabled(boolean substitutionEnabled) {
        if (this._substitutionEnabled != substitutionEnabled) {
            this._substitutionEnabled = substitutionEnabled;
            this.getThisLogger().trace(ServiceMessages.SUBSTITUTION_ENABLED, ValueConverter.toInteger(this._substitutionEnabled));
        }
    }

    protected abstract void setURL(@Nonnull URL var1);

    @Nonnull
    @CheckReturnValue
    final XMLDocument _getDocument() {
        return Require.notNull(this._document);
    }

    @Nonnull
    @CheckReturnValue
    final List<Handler> _getHandlers() {
        return this._handlers;
    }

    final void _setLang(@Nonnull Optional<String> lang) {
        this._lang = lang;
    }

    @Nonnull
    @CheckReturnValue
    abstract Config getConfig();

    @Nonnull
    @CheckReturnValue
    final URL getContextURL() {
        return this._urls.isEmpty() ? this.getURL() : this._urls.getLast();
    }

    @Nonnull
    @CheckReturnValue
    final Optional<HashMap<String, Entity>> getEntities() {
        return this._entities;
    }

    @Nonnull
    @CheckReturnValue
    final Optional<String> getLang() {
        return this._lang;
    }

    @CheckReturnValue
    final boolean include(@Nonnull String from, boolean verify, @Nonnull String[] verifyKeyIdents, boolean decrypt, @Nonnull String[] decryptKeyIdents, @Nonnull Optional<String> security, boolean optional) {
        URL fromURL = this.getConfig().createURL(from, Optional.of(this.getContextURL()));
        if (fromURL == null) {
            return false;
        }
        if (this.getConfig().isIncluded(fromURL)) {
            this.getThisLogger().debug(ServiceMessages.REDUNDANT_INCLUDE, this.getRootName(), fromURL);
        } else {
            DocumentReader documentReader;
            try {
                documentReader = DocumentReader.create(fromURL, Optional.empty(), Optional.empty());
            }
            catch (FileNotFoundException exception) {
                return this._fileNotFound(fromURL, optional, exception);
            }
            this.getThisLogger().debug(ServiceMessages.INCLUDING, this.getRootName(), documentReader.getFromURL());
            if (verify || decrypt) {
                KeyedGroups securityProperties;
                XMLDocument xmlDocument = new XMLDocument();
                try {
                    xmlDocument.parse(documentReader);
                }
                catch (XMLDocument.ParseException exception) {
                    throw new RuntimeException(exception.getCause());
                }
                try {
                    documentReader.close();
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
                SecurityContext securityContext = new SecurityContext(this._logger);
                ConfigProperties configProperties = this.getConfig().getProperties();
                KeyedGroups keyedGroups = securityProperties = security.isPresent() ? ((KeyedGroups)configProperties).getGroup(security.get()) : KeyedGroups.MISSING_KEYED_GROUP;
                if (!securityContext.setUp(configProperties, securityProperties)) {
                    return false;
                }
                Crypt crypt = new Crypt();
                if (!crypt.setUp(securityContext.getCryptProperties(), Optional.empty())) {
                    return false;
                }
                Serializable serializable = crypt.load(xmlDocument, from, verify, verifyKeyIdents, decrypt, decryptKeyIdents);
                if (serializable == null) {
                    return false;
                }
                try {
                    documentReader = DocumentReader.create(fromURL, Optional.of(new StringReader(String.valueOf(serializable))), documentReader.getStamp());
                }
                catch (FileNotFoundException exception) {
                    throw new InternalError(exception);
                }
            }
            this._read(documentReader);
        }
        return !this.getThisLogger().hasLogged(Logger.LogLevel.ERROR);
    }

    final void putEntity(@Nonnull String key, @Nonnull Entity entity, boolean supersede) {
        String entityKey = DocumentLoader._entityKey(key, entity.getPrefix());
        if (!this._entities.isPresent()) {
            this._entities = Optional.of(new HashMap());
        }
        if (this._entities.get().put(entityKey, entity) != null && !supersede) {
            this.getThisLogger().error(ServiceMessages.MULTIPLE_ENTITY_DEFINITION, this.getPrefixName(entity.getPrefix()), key);
        }
    }

    @CheckReturnValue
    final boolean reference(@Nonnull String from) {
        DocumentStream stream;
        URL fromURL = this.getConfig().createURL(from, Optional.of(this.getContextURL()));
        if (fromURL == null) {
            return false;
        }
        try {
            stream = DocumentStream.create(fromURL);
            stream.close();
        }
        catch (FileNotFoundException exception) {
            this.getThisLogger().error(ServiceMessages.REFERENCE_FAILED, exception.getMessage());
            return false;
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        this.updateStamp(stream.getStamp());
        return true;
    }

    final void removeEntity(@Nonnull String key, @Nonnull String prefix) {
        Require.success(this._entities.isPresent() && this._entities.get().remove(DocumentLoader._entityKey(key, prefix)) != null);
    }

    @Nonnull
    @CheckReturnValue
    final String substitute(@Nonnull String text) {
        return Require.notNull(this._substitutionEnabled ? this.getConfig().substitute(text, this._substitutionDeferred) : text);
    }

    final void updateStamp(@Nonnull Optional<DateTime> stamp) {
        this.getConfig().updateStamp(stamp);
    }

    private static String _entityKey(String key, String prefix) {
        if (UUID.isUUID(key = key.trim())) {
            UUID uuid = UUID.fromString(key).get();
            key = uuid.toRawString();
        } else if (!ID_PATTERN.matcher(key = key.toUpperCase(Locale.ROOT)).matches()) {
            key = prefix + key;
        }
        return key;
    }

    private boolean _fileNotFound(URL fromURL, boolean optional, FileNotFoundException exception) {
        if (optional) {
            this.getThisLogger().debug(ServiceMessages.OPTIONAL_INCLUDE, this.getRootName(), fromURL);
            return true;
        }
        this.getThisLogger().error(ServiceMessages.INCLUDE_FAILED, this.getRootName(), this.getURL(), exception.getMessage());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _read(DocumentReader documentReader) {
        this.updateStamp(documentReader.getStamp());
        this._urls.addLast(documentReader.getFromURL());
        this._document = new XMLDocument();
        this._document.setElementFactory(this);
        this._document.setPIHandler(Optional.of(new DocumentPIHandler(this)));
        this._document.setValidating(this._validating);
        this._registerHandlers();
        Object savedValues = this.getConfig().getProperties().saveMonitoredValues();
        try {
            this._document.parse(documentReader);
        }
        catch (XMLDocument.ParseException exception) {
            if (!(exception.getCause() instanceof XMLDocument.PIHandler.PIException)) {
                String message = exception.getCause().getMessage();
                this.getThisLogger().error((Throwable)exception, BaseMessages.VERBATIM, message != null ? message : exception.getMessage());
            }
        }
        finally {
            this.getConfig().getProperties().restoreMonitoredValues(savedValues);
        }
        this._urls.removeLast();
    }

    private void _registerHandlers() {
        this._document.setDefaultHandler(Optional.of(new Handler(Optional.empty(), Optional.empty())));
        for (Handler handler : this._getHandlers()) {
            this._document.setElementHandler(handler.getPath(), Optional.of(handler));
        }
        this._document.setElementHandler("/" + this.getRootName(), Optional.of(this.getRootHandler()));
    }

    static {
        URLHandlerFactory.register("resource", new ResourceURLHandler());
    }

    class RootHandler
    implements XMLElement.Handler {
        private DocumentElement _element;
        private boolean _enabled = true;

        RootHandler() {
        }

        @Override
        public XMLElement onElementEnd(XMLElement element) {
            Require.success(element instanceof DocumentElement);
            this._element = (DocumentElement)element;
            this.onRootEnd();
            return null;
        }

        @Override
        public XMLElement onElementStart(XMLElement element) {
            Require.success(element instanceof DocumentElement);
            this._element = (DocumentElement)element;
            Optional<String> condition = this.getAttribute("if");
            if (condition.isPresent() && !DocumentLoader.this.getConfig().getStringValue(condition.get()).isPresent()) {
                this._enabled = false;
            }
            if ((condition = this.getAttribute("unless")).isPresent() && DocumentLoader.this.getConfig().getStringValue(condition.get()).isPresent()) {
                this._enabled = false;
            }
            if (this._enabled) {
                DocumentLoader.this._setLang(this.getAttribute("lang"));
            } else {
                for (Handler handler : DocumentLoader.this._getHandlers()) {
                    DocumentLoader.this._getDocument().setElementHandler(handler.getPath(), Optional.empty());
                }
            }
            return element;
        }

        @Nonnull
        @CheckReturnValue
        protected final Optional<String> getAttribute(@Nonnull String name) {
            return this._element.getAttributeValue(name, Optional.empty());
        }

        @CheckReturnValue
        protected final boolean isEnabled() {
            return this._enabled;
        }

        protected void onRootEnd() {
        }
    }

    final class Handler
    implements XMLElement.Handler {
        private final Optional<DocumentElementLoader> _loader;
        private final Optional<String> _path;

        Handler(@Nonnull Optional<String> path, Optional<DocumentElementLoader> loader) {
            this._path = path;
            this._loader = loader;
            if (this._loader.isPresent()) {
                this._loader.get().setDocument(DocumentLoader.this);
            }
        }

        @Override
        public XMLElement onElementEnd(XMLElement element) {
            if (this._loader.isPresent()) {
                Require.success(element instanceof DocumentElement);
                if (!element.getAttributeValue("lang", Optional.empty()).isPresent()) {
                    try {
                        this._loader.get().process((DocumentElement)element);
                    }
                    catch (ValidationException exception) {
                        DocumentLoader.this.getThisLogger().error(BaseMessages.VERBATIM, exception.getMessage());
                    }
                } else {
                    this._loader.get().updateTexts((DocumentElement)element);
                }
                return null;
            }
            return element;
        }

        @Override
        public XMLElement onElementStart(XMLElement element) {
            return element;
        }

        @Nonnull
        @CheckReturnValue
        String getPath() {
            return this._path.get();
        }
    }
}

