/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.ValueConverter;
import org.rvpf.base.util.container.KeyedValues;
import org.rvpf.base.xml.XMLDocument;
import org.rvpf.config.Config;
import org.rvpf.document.loader.DocumentLoader;
import org.rvpf.service.ServiceMessages;

@ThreadSafe
final class DocumentPIHandler
implements XMLDocument.PIHandler {
    public static final String DEBUG_LEVEL = "debug";
    public static final String DECRYPT_ARGUMENT = "decrypt";
    public static final String DECRYPT_KEY_ARGUMENT = "decryptKey";
    public static final String ECHO_INSTRUCTION = "echo";
    public static final String ERROR_LEVEL = "error";
    public static final String HREF_ARGUMENT = "href";
    public static final String IF_ARGUMENT = "if";
    public static final String INCLUDE_INSTRUCTION = "include";
    public static final String INFO_LEVEL = "info";
    public static final String LEVEL_ARGUMENT = "level";
    public static final String LOG_INSTRUCTION = "log";
    public static final String MESSAGE_ARGUMENT = "message";
    public static final String OPTIONAL_ARGUMENT = "optional";
    public static final String REFERENCE_INSTRUCTION = "reference";
    public static final String SECURITY_ARGUMENT = "security";
    public static final String UNLESS_ARGUMENT = "unless";
    public static final String VERIFY_ARGUMENT = "verify";
    public static final String VERIFY_KEY_ARGUMENT = "verifyKey";
    public static final String WARN_LEVEL = "warn";
    private final Logger _logger;
    private final DocumentLoader _owner;

    DocumentPIHandler(DocumentLoader owner) {
        this._owner = owner;
        this._logger = Logger.getInstance(owner != null ? owner.getClass() : this.getClass());
    }

    @Override
    public void onPI(String target, String data) throws XMLDocument.PIHandler.PIException {
        boolean enabled;
        KeyedValues values = DocumentPIHandler._getValues(data);
        String property = this._getValue(IF_ARGUMENT, values);
        boolean bl = enabled = property == null || this._getContextProperty(property) != null;
        if (enabled) {
            property = this._getValue(UNLESS_ARGUMENT, values);
            boolean bl2 = enabled = property == null || this._getContextProperty(property) == null;
        }
        if (enabled) {
            switch (target.toLowerCase(Locale.ROOT)) {
                case "echo": {
                    this._echo(values);
                    break;
                }
                case "log": {
                    this._log(values);
                    break;
                }
                case "include": {
                    this._include(values);
                    break;
                }
                case "reference": {
                    this._reference(values);
                    break;
                }
            }
        }
    }

    private static KeyedValues _getValues(String data) {
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(data));
        KeyedValues values = new KeyedValues();
        tokenizer.resetSyntax();
        tokenizer.wordChars(97, 122);
        tokenizer.wordChars(65, 90);
        tokenizer.whitespaceChars(0, 32);
        tokenizer.quoteChar(34);
        tokenizer.quoteChar(39);
        tokenizer.lowerCaseMode(true);
        try {
            while (tokenizer.nextToken() == -3) {
                String name = tokenizer.sval;
                if (tokenizer.nextToken() == 61) {
                    tokenizer.nextToken();
                    if (tokenizer.ttype == 39 || tokenizer.ttype == 34) {
                        values.add(name, tokenizer.sval);
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return values;
    }

    private void _echo(KeyedValues values) throws XMLDocument.PIHandler.PIException {
        String message = this._getValue(MESSAGE_ARGUMENT, values);
        if (message == null) {
            this._logger.error(ServiceMessages.MISSING_PI_ARGUMENT, MESSAGE_ARGUMENT, ECHO_INSTRUCTION);
            throw new XMLDocument.PIHandler.PIException();
        }
        System.out.println(message);
    }

    private String _getContextProperty(String name) {
        Config config = this._owner != null ? this._owner.getConfig() : null;
        String value = config != null ? (String)config.getStringValue(name).orElse(null) : System.getProperty(name);
        return value;
    }

    private String _getValue(String name, KeyedValues values) {
        Optional<String> text = values.getString(name);
        return this._owner != null && text.isPresent() ? this._owner.substitute(text.get()) : (String)text.orElse(null);
    }

    private String[] _getValues(String name, KeyedValues values) {
        String[] texts = values.getStrings(name);
        if (this._owner != null) {
            for (int i = 0; i < texts.length; ++i) {
                texts[i] = this._owner.substitute(texts[i]);
            }
        }
        return texts;
    }

    private void _include(KeyedValues values) throws XMLDocument.PIHandler.PIException {
        if (this._owner != null) {
            boolean optional;
            Optional<String> security;
            String[] decryptKeyIdents;
            boolean decrypt;
            String[] verifyKeyIdents;
            String href = this._getValue(HREF_ARGUMENT, values);
            if (href == null) {
                this._logger.error(ServiceMessages.MISSING_PI_ARGUMENT, HREF_ARGUMENT, INCLUDE_INSTRUCTION);
                throw new XMLDocument.PIHandler.PIException();
            }
            boolean verify = ValueConverter.convertToBoolean(ServiceMessages.ATTRIBUTE_TYPE.toString(), VERIFY_ARGUMENT, Optional.ofNullable(this._getValue(VERIFY_ARGUMENT, values)), false);
            if (!this._owner.include(href, verify, verifyKeyIdents = this._getValues(VERIFY_KEY_ARGUMENT, values), decrypt = ValueConverter.convertToBoolean(ServiceMessages.ATTRIBUTE_TYPE.toString(), DECRYPT_ARGUMENT, Optional.ofNullable(this._getValue(DECRYPT_ARGUMENT, values)), false), decryptKeyIdents = this._getValues(DECRYPT_KEY_ARGUMENT, values), security = Optional.ofNullable(this._getValue(SECURITY_ARGUMENT, values)), optional = ValueConverter.convertToBoolean(ServiceMessages.ATTRIBUTE_TYPE.toString(), OPTIONAL_ARGUMENT, Optional.ofNullable(this._getValue(OPTIONAL_ARGUMENT, values)), false))) {
                throw new XMLDocument.PIHandler.PIException();
            }
        } else {
            this._logger.warn(ServiceMessages.INCLUDE_NEEDS_OWNER, new Object[0]);
        }
    }

    private void _log(KeyedValues values) throws XMLDocument.PIHandler.PIException {
        String message = this._getValue(MESSAGE_ARGUMENT, values);
        if (message == null) {
            this._logger.error(ServiceMessages.MISSING_PI_ARGUMENT, MESSAGE_ARGUMENT, LOG_INSTRUCTION);
            throw new XMLDocument.PIHandler.PIException();
        }
        String level = this._getValue(LEVEL_ARGUMENT, values);
        if (level == null || INFO_LEVEL.equalsIgnoreCase(level)) {
            this._logger.info(ServiceMessages.DOCUMENT_LOG, message);
        } else if (DEBUG_LEVEL.equalsIgnoreCase(level)) {
            this._logger.debug(ServiceMessages.DOCUMENT_LOG, message);
        } else if (WARN_LEVEL.equalsIgnoreCase(level)) {
            this._logger.warn(ServiceMessages.DOCUMENT_LOG, message);
        } else {
            if (ERROR_LEVEL.equalsIgnoreCase(level)) {
                this._logger.error(ServiceMessages.DOCUMENT_LOG, message);
                throw new XMLDocument.PIHandler.PIException();
            }
            this._logger.warn(ServiceMessages.LOG_LEVEL_UNKNOWN, level);
            this._logger.info(ServiceMessages.DOCUMENT_LOG, message);
        }
    }

    private void _reference(KeyedValues values) throws XMLDocument.PIHandler.PIException {
        if (this._owner != null) {
            String href = this._getValue(HREF_ARGUMENT, values);
            if (href == null) {
                this._logger.error(ServiceMessages.MISSING_PI_ARGUMENT, HREF_ARGUMENT, REFERENCE_INSTRUCTION);
                throw new XMLDocument.PIHandler.PIException();
            }
            if (!this._owner.reference(href)) {
                throw new XMLDocument.PIHandler.PIException();
            }
        }
    }
}

