/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.base.logger.Logger;
import org.rvpf.document.loader.DocumentStream;
import org.rvpf.service.ServiceMessages;

public final class DocumentPropertiesMap
extends LinkedHashMap<String, String> {
    private static final long serialVersionUID = 1L;
    private Optional<DateTime> _stamp = Optional.empty();

    @Nonnull
    @CheckReturnValue
    public static DocumentPropertiesMap fetch(@Nonnull DocumentStream documentStream, @Nonnull Optional<Reader> reader) throws IOException {
        final DocumentPropertiesMap map = new DocumentPropertiesMap();
        Properties properties = new Properties(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object put(Object key, Object value) {
                String previousValue = map.put((String)key, (String)value);
                if (previousValue != null) {
                    Logger.getInstance(DocumentPropertiesMap.class).debug(ServiceMessages.PREVIOUS_VALUE_OVERRIDDEN, key, value);
                }
                return previousValue;
            }
        };
        map._setStamp(documentStream.getStamp());
        if (reader.isPresent()) {
            properties.load(reader.get());
            reader.get().close();
        } else {
            if (documentStream.getFromURL().getFile().toLowerCase(Locale.ROOT).endsWith(".xml")) {
                properties.loadFromXML(documentStream);
            } else {
                properties.load(documentStream);
            }
            documentStream.close();
        }
        return map;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<DateTime> getStamp() {
        return this._stamp;
    }

    private void _setStamp(Optional<DateTime> stamp) {
        this._stamp = stamp;
    }
}

