/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.document.loader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.util.UnicodeStreamReader;
import org.rvpf.document.loader.DocumentStream;
import org.rvpf.service.ServiceMessages;

final class DocumentReader
extends BufferedReader {
    private final URL _fromURL;
    private final Optional<DateTime> _stamp;

    private DocumentReader(Optional<Reader> reader, URL fromURL, Optional<DateTime> stamp) {
        super(reader.get());
        this._fromURL = fromURL;
        this._stamp = stamp;
    }

    @Nonnull
    @CheckReturnValue
    static DocumentReader create(@Nonnull URL fromURL, @Nonnull Optional<Reader> reader, @Nonnull Optional<DateTime> stamp) throws FileNotFoundException {
        if (!reader.isPresent()) {
            try {
                DocumentStream documentStream = DocumentStream.create(fromURL);
                fromURL = documentStream.getFromURL();
                stamp = documentStream.getStamp();
                if (documentStream.isFile()) {
                    reader = Optional.of(new UnicodeStreamReader(documentStream.getStream()));
                }
                Optional<String> encoding = documentStream.getEncoding();
                reader = Optional.of(new InputStreamReader(documentStream.getStream(), encoding.isPresent() ? encoding.get() : StandardCharsets.UTF_8.name()));
            }
            catch (FileNotFoundException exception) {
                throw exception;
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        } else if (!stamp.isPresent()) {
            long lastModified = new File(fromURL.getPath()).lastModified();
            if (lastModified > 0L) {
                stamp = Optional.of(DateTime.fromMillis(lastModified));
            } else {
                Logger.getInstance(DocumentReader.class).warn(ServiceMessages.TIME_NOT_AVAILABLE, fromURL);
            }
        }
        return new DocumentReader(reader, fromURL, stamp);
    }

    @Nonnull
    @CheckReturnValue
    URL getFromURL() {
        return this._fromURL;
    }

    @Nonnull
    @CheckReturnValue
    Optional<DateTime> getStamp() {
        return this._stamp;
    }
}

